/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.swing;

import com.ur.lang.StringUtils;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import org.jsoup.Jsoup;
import org.jsoup.examples.HtmlToPlainText;
import org.jsoup.nodes.Element;

public class HTML {
    public static final String PADDING_TOP = "padding-top";
    public static final String PADDING_LEFT = "padding-left";
    public static final String PADDING_BOTTOM = "padding-bottom";
    public static final String PADDING_RIGHT = "padding-right";
    private static final String tagStart = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>";
    private static final String tagEnd = "\\</\\w+\\>";
    private static final String tagSelfClosing = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>";
    private static final String htmlEntity = "&[a-zA-Z][a-zA-Z0-9]+;";
    private static final Pattern htmlPattern = Pattern.compile("(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>.*\\</\\w+\\>)|(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>)|(&[a-zA-Z][a-zA-Z0-9]+;)", 32);
    private static final Font FONT = new Font("Ariel", 0, 12);

    public static String html(String page) {
        return HTML.wrapTag(HTML.Tag.HTML.toString(), page, true);
    }

    public static String body(String page) {
        return HTML.wrapTag(HTML.Tag.BODY.toString(), page, true);
    }

    public static String pre(String page) {
        return HTML.wrapTag(HTML.Tag.PRE.toString(), page, true);
    }

    public static String space() {
        return "&nbsp;";
    }

    public static String form(String content) {
        return HTML.wrapTag(HTML.Tag.FORM.toString(), content);
    }

    public static String label(String text) {
        return text;
    }

    public static String selector(String id) {
        return "<select id=\"" + id + "\" />";
    }

    public static String h1(String text) {
        return HTML.wrapTag("h1", text);
    }

    public static String h2(String text) {
        return HTML.wrapTag("h2", text);
    }

    public static String h3(String text) {
        return HTML.wrapTag("h3", text);
    }

    public static String fontBold(String text) {
        return HTML.wrapTag("b", text);
    }

    public static String fontItalic(String text) {
        return HTML.wrapTag("i", text);
    }

    public static String center(String content) {
        return HTML.wrapTag("center", content);
    }

    public static String image(Align alignment, URL urlToSource) {
        return "<img align=\"" + alignment.name() + "\" src=\"" + urlToSource.toString() + "\">";
    }

    public static String p(String paragraph) {
        return HTML.wrapTag("p", paragraph);
    }

    public static String br() {
        return "<br/>";
    }

    public static String small(String content) {
        return "<small>" + content + "</small>";
    }

    public static String hr(String color) {
        return "<hr color=" + color + ">";
    }

    public static String div(String content) {
        return HTML.wrapTag("div", content);
    }

    public static String table(int width, String ... rows) {
        return HTML.table(width, Arrays.asList(rows));
    }

    public static String table(int width, Iterable<String> rows) {
        String result = "";
        for (String each : rows) {
            result = String.valueOf(result) + each;
        }
        return HTML.tableWithProperties("Cellpadding=\"3\" Cellspacing=\"0.5\" Align=\"center\" Width=\"" + width + "\"", result);
    }

    public static String tableWithProperties(String properties, String ... rows) {
        return HTML.tableWithProperties(properties, Arrays.asList(rows));
    }

    public static String tableWithProperties(String properties, Iterable<String> rows) {
        String result = "";
        for (String each : rows) {
            result = String.valueOf(result) + each;
        }
        return HTML.wrapTag("table", properties, result);
    }

    public static String tableRow(String ... cells) {
        return HTML.tableRowWithProperties("", cells);
    }

    public static String tableRow(Iterable<String> cells) {
        return HTML.tableRowWithProperties("", cells);
    }

    public static String tableRowWithProperties(String properties, String ... cells) {
        String result = "";
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            result = String.valueOf(result) + each;
            ++n2;
        }
        return HTML.wrapTag("tr", properties, result);
    }

    public static String tableRowWithProperties(String properties, Iterable<String> cells) {
        String result = "";
        for (String each : cells) {
            result = String.valueOf(result) + each;
        }
        return HTML.wrapTag("tr", properties, result);
    }

    public static String tableHeader(String data) {
        return HTML.tableHeaderWithProperties("", data);
    }

    public static String tableHeaderWithPropertiesWrappedAfterFirstWord(String properties, String data) {
        return HTML.tableHeaderWithProperties(properties, data.replaceFirst("\\s", "<br/>"));
    }

    public static String tableHeaderWithProperties(String properties, String data) {
        return HTML.wrapTag("th", properties, data.replaceAll("\\s", "&nbsp;"));
    }

    public static String tableHeaderSpacer() {
        return HTML.wrapTag("th", "&nbsp;");
    }

    public static String tableCell(String data) {
        return HTML.tableCellWithProperties("", data);
    }

    public static String tableCellNumber(double data) {
        return HTML.tableCellWithProperties("align='right'", String.valueOf(data));
    }

    public static String tableCellNumber(long data) {
        return HTML.tableCellWithProperties("align='right'", String.valueOf(data));
    }

    public static String tableCellNumber(String data) {
        return HTML.tableCellWithProperties("align='right'", String.valueOf(data));
    }

    public static String tableCellNumber(String value, Format format) {
        String formattedValue = format.format(value);
        return HTML.tableCellWithProperties("align='right'", formattedValue);
    }

    public static String tableCellAlignTop(String data) {
        return HTML.tableCellWithProperties("valign='top'", data);
    }

    public static String tableCellWithProperties(String properties, String data) {
        return HTML.wrapTag("td", properties, data);
    }

    public static String fontSize(String size, String content) {
        return HTML.format("<font size=%s>%s</font>", size, content);
    }

    public static String fontBackgroundColor(String color, String content) {
        return HTML.format("<font bgcolor=%s>%s</font>", color, content);
    }

    public static String fontColor(String color, String content) {
        return HTML.format("<font color=%s>%s</font>", color, content);
    }

    public static String fontRGBColor(String rgb, String content) {
        return HTML.format("<font color=%s>%s</font>", rgb, content);
    }

    public static String unHtml(String content) {
        return Jsoup.parse((String)content).text();
    }

    public static String link(String link, String text) {
        return HTML.format("<a href=\"%s\">%s</a>", link, text);
    }

    private static String wrapTag(String tag, String content) {
        return HTML.wrapTag(tag, content, false);
    }

    private static String wrapTag(String tag, String content, boolean removeExistingWrapping) {
        if (content == null) {
            content = "";
        }
        if (removeExistingWrapping) {
            content = StringUtils.trimStartAndEnd("<" + tag + ">", "</" + tag + ">", content);
        }
        return HTML.format("<%s>%s</%s>", tag, content, tag);
    }

    private static String wrapTag(String tag, String properties, String content) {
        return HTML.format("<%s %s>%s</%s>", tag, properties, content, tag);
    }

    public static String italic(String label) {
        return HTML.format("<i>%s</i>", label);
    }

    public static String indentTop(int paddingTop, String message) {
        return HTML.format(HTML.divWithStyles(message, new HTMLAttribute(PADDING_TOP, Integer.toString(paddingTop))), new String[0]);
    }

    public static String indentLeft(int paddingLeft, String message) {
        return HTML.format(HTML.divWithStyles(message, new HTMLAttribute(PADDING_LEFT, Integer.toString(paddingLeft))), new String[0]);
    }

    public static String indentBottom(int paddingBottom, String message) {
        return HTML.format(HTML.divWithStyles(message, new HTMLAttribute(PADDING_BOTTOM, Integer.toString(paddingBottom))), new String[0]);
    }

    public static String indentRight(int paddingRight, String message) {
        return HTML.format(HTML.divWithStyles(message, new HTMLAttribute(PADDING_RIGHT, Integer.toString(paddingRight))), new String[0]);
    }

    public static String indent(int paddingTop, int paddingLeft, int paddingBottom, int paddingRight, String message) {
        return HTML.format(HTML.divWithStyles(message, new HTMLAttribute(PADDING_TOP, Integer.toString(paddingTop)), new HTMLAttribute(PADDING_LEFT, Integer.toString(paddingLeft)), new HTMLAttribute(PADDING_BOTTOM, Integer.toString(paddingBottom)), new HTMLAttribute(PADDING_RIGHT, Integer.toString(paddingRight))), new String[0]);
    }

    private static String divWithStyles(String message, HTMLAttribute ... attributes) {
        String divStyleBegin = "<div style=\"";
        String divStyleEnd = "\">%s</div>";
        String style = "";
        String[] args = new String[attributes.length * 2 + 1];
        int idx = 0;
        int i = 0;
        while (i < attributes.length) {
            style = String.valueOf(style) + "%s:%spx;";
            args[idx++] = attributes[i].name;
            args[idx++] = attributes[i].value;
            ++i;
        }
        args[idx] = message;
        return HTML.format(String.valueOf(divStyleBegin) + style + divStyleEnd, args);
    }

    public static String maxWidth(int maxWidth, String message) {
        if (message == null) {
            return "";
        }
        if (HTML.widthOfStringInPixels(message) > (double)maxWidth) {
            return HTML.format(HTML.divWithStyle("width", Integer.toString(maxWidth), message), new String[0]);
        }
        return message;
    }

    public static String divWithStyle(String style, String argument, String message) {
        return HTML.format("<div style=\"%s:%spx\">%s</div>", style, argument, message);
    }

    public static String centerText(String message) {
        return HTML.format("<div style='text-align:center'>%s</div>", message);
    }

    private static String format(String format, String ... args) {
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].replace("%", "&#37;");
            ++i;
        }
        return String.format(format, args);
    }

    private static double widthOfStringInPixels(String message) {
        if (message.contains("</html>")) {
            return 0.0;
        }
        Object antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        Object fractionalmetricsHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        FontRenderContext fontRenderContext = new FontRenderContext(null, antiAliasHint, fractionalmetricsHint);
        return FONT.getStringBounds(message, fontRenderContext).getWidth();
    }

    public static String unorderedList(String content) {
        return HTML.wrapTag("ul", content);
    }

    public static String unorderedList(Iterable<String> content) {
        StringBuilder listItems = new StringBuilder();
        for (String item : content) {
            listItems.append(HTML.li(item));
        }
        return HTML.unorderedList(listItems.toString());
    }

    public static String orderedList(String content) {
        return HTML.wrapTag("ol", content);
    }

    public static String li(String content) {
        return HTML.wrapTag("li", content);
    }

    public static String convertToHtml(String programName) {
        String result = "";
        char[] cArray = programName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            switch (each) {
                case '\"': {
                    result = String.valueOf(result) + "&quot;";
                    break;
                }
                case '<': {
                    result = String.valueOf(result) + "&lt;";
                    break;
                }
                case '>': {
                    result = String.valueOf(result) + "&gt;";
                    break;
                }
                case '&': {
                    result = String.valueOf(result) + "&amp;";
                    break;
                }
                default: {
                    result = String.valueOf(result) + each;
                }
            }
            ++n2;
        }
        return result;
    }

    public static String lineBreakText(String text, int lineLength) {
        int i;
        if (text.length() > lineLength && (i = text.indexOf(" ", lineLength)) > 0) {
            text = String.format("%s%s%s", text.substring(0, i), HTML.br(), HTML.lineBreakText(text.substring(i).trim(), lineLength));
        }
        return text;
    }

    public static String truncateLongWordsWithDots(double maxPixels, String line) {
        if (HTML.isHtml(line)) {
            return line;
        }
        return HTML.truncateWordsWithDots(maxPixels, line);
    }

    private static String truncateWordsWithDots(double maxPixels, String line) {
        String[] longestWords = HTML.findWordsLongerThan(maxPixels, line);
        String result = line;
        if (line != null && line.length() > 0 && longestWords.length > 0) {
            String[] stringArray = longestWords;
            int n = longestWords.length;
            int n2 = 0;
            while (n2 < n) {
                String longWord = stringArray[n2];
                result = HTML.truncateWordWithDots(longWord, maxPixels, line);
                ++n2;
            }
        }
        return result;
    }

    public static String truncateTextWithDots(double maxPixels, String line) {
        if (HTML.isHtml(line)) {
            return line;
        }
        String result = HTML.truncateWordsWithDots(maxPixels, line);
        result = HTML.truncateLineWithDots(result, maxPixels);
        return result;
    }

    public static boolean isHtml(String string) {
        boolean ret = false;
        if (string != null) {
            ret = htmlPattern.matcher(string).find();
        }
        return ret;
    }

    public static String toPlainText(String line) {
        return new HtmlToPlainText().getPlainText((Element)Jsoup.parse((String)line));
    }

    private static String truncateWordWithDots(String word, double maxPixels, String line) {
        double letterSize;
        String result = line;
        if (word != null && word.length() > 0 && (letterSize = HTML.widthOfStringInPixels(word) / (double)word.length()) > 0.0) {
            int maxNoOfLetters = (int)Math.round(maxPixels / letterSize);
            result = line.replace(word, StringUtils.safeLimitedSizeStringWithDots(maxNoOfLetters, word));
        }
        return result;
    }

    private static String truncateLineWithDots(String line, double maxPixels) {
        double letterSize;
        String result = line;
        if (line != null && line.length() > 0 && (letterSize = HTML.widthOfStringInPixels(line) / (double)line.length()) > 0.0) {
            int maxNoOfLetters = (int)Math.round(maxPixels / letterSize);
            result = StringUtils.safeLimitedSizeStringWithDots(maxNoOfLetters, line);
        }
        return result;
    }

    private static String[] findWordsLongerThan(double maxPixels, String line) {
        ArrayList<String> longestWords = new ArrayList<String>();
        if (line != null) {
            String[] words;
            String[] stringArray = words = line.split("\\s+");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                double width = HTML.widthOfStringInPixels(word);
                if (width >= maxPixels) {
                    longestWords.add(word);
                }
                ++n2;
            }
        }
        return longestWords.toArray(new String[0]);
    }

    public static String fillToMinimumLength(String s, int length) {
        int additionalLength = length - s.length();
        StringBuilder sBuilder = new StringBuilder(s);
        int i = 0;
        while (i < additionalLength) {
            sBuilder.append("&nbsp;");
            ++i;
        }
        return sBuilder.toString();
    }

    public static enum Align {
        top,
        middle,
        bottom;

    }

    private static class HTMLAttribute {
        public String name = "";
        public String value = "";

        public HTMLAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

