/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class LayeredIcon
implements Icon {
    private List<Icon> layers = new ArrayList<Icon>();
    private int width;
    private int height;

    public LayeredIcon(Icon first, Icon ... icons) {
        this.layers.add(first);
        this.layers.addAll(Arrays.asList(icons));
        this.width = first.getIconWidth();
        this.height = first.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        for (Icon each : this.layers) {
            each.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void addLayer(Icon icon) {
        this.layers.add(icon);
    }

    public void setLayer(int index, Icon icon) {
        this.layers.set(index, icon);
    }

    public void removeLayer(int index) {
        this.layers.remove(index);
    }
}

