/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.swing;

import com.ur.util.swing.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class SizedIcon
implements Icon {
    private static final Icon NULL_ICON = new EmptyIcon(0, 0);
    private final Icon smallIcon;
    private final int width;
    private final int height;

    public SizedIcon(Icon smallIcon, int width, int height) {
        this.smallIcon = this.handleNullIcon(smallIcon);
        this.width = width;
        this.height = height;
    }

    private Icon handleNullIcon(Icon icon) {
        return icon == null ? NULL_ICON : icon;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        float iconX = (float)this.getIconWidth() / 2.0f - (float)this.smallIcon.getIconWidth() / 2.0f;
        float iconY = (float)this.getIconHeight() / 2.0f - (float)this.smallIcon.getIconHeight() / 2.0f;
        this.smallIcon.paintIcon(c, g, (int)iconX, (int)iconY);
    }
}

