/*
 * Decompiled with CFR 0.152.
 */
package com.ur.util.swing;

import com.ur.util.swing.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class TwoIcons
implements Icon {
    private static final Icon NULL_ICON = new EmptyIcon(0, 0);
    private Icon leftIcon;
    private Icon rightIcon;
    private int width;
    private int height;

    public TwoIcons() {
        this(NULL_ICON, NULL_ICON, 0, 0);
    }

    public TwoIcons(Icon leftIcon, Icon rightIcon, int width, int height) {
        this.leftIcon = this.handleNullIcon(leftIcon);
        this.rightIcon = this.handleNullIcon(rightIcon);
        this.width = width;
        this.height = height;
    }

    private Icon handleNullIcon(Icon icon) {
        return icon == null ? NULL_ICON : icon;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        float leftX = (float)this.getIconWidth() / 4.0f - (float)this.leftIcon.getIconWidth() / 2.0f;
        float leftY = (float)this.getIconHeight() / 2.0f - (float)this.leftIcon.getIconHeight() / 2.0f;
        this.leftIcon.paintIcon(c, g, x + (int)leftX, y + (int)leftY);
        float rightX = (float)this.getIconWidth() * 3.0f / 4.0f - (float)this.rightIcon.getIconWidth() / 2.0f;
        float rightY = (float)this.getIconHeight() / 2.0f - (float)this.rightIcon.getIconHeight() / 2.0f;
        this.rightIcon.paintIcon(c, g, x + (int)rightX, y + (int)rightY);
    }

    public void setLeftIcon(Icon icon) {
        this.leftIcon = this.handleNullIcon(icon);
        this.calculateDimension();
    }

    public void setRightIcon(Icon icon) {
        this.rightIcon = this.handleNullIcon(icon);
        this.calculateDimension();
    }

    private void calculateDimension() {
        this.width = this.rightIcon.getIconWidth() + this.leftIcon.getIconWidth();
        this.height = Math.max(this.rightIcon.getIconHeight(), this.leftIcon.getIconHeight());
    }
}

