/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.system.diagnostics.Watcher;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ApplicationDiagnosticsThread {
    private static final Logger LOG = LogFactory.createLogger(ApplicationDiagnosticsThread.class);
    private final Set<Watcher> watchers;
    private long timeToMonitorWatchers = TimeUnit.SECONDS.toMillis(30L);

    @Inject
    public ApplicationDiagnosticsThread(Set<Watcher> watchers) {
        this.watchers = watchers;
        LOG.info("Starting Watchers", new Object[0]);
        for (Watcher each : watchers) {
            each.start();
        }
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new ResetTriggeredWatchers(watchers), this.timeToMonitorWatchers, this.timeToMonitorWatchers);
    }

    public void stopWatchers() {
        LOG.info("Stopping Watchers", new Object[0]);
        for (Watcher each : this.watchers) {
            each.stop();
        }
    }

    private static class ResetTriggeredWatchers
    extends TimerTask {
        private final Set<Watcher> watchers;

        public ResetTriggeredWatchers(Set<Watcher> watchers) {
            this.watchers = watchers;
        }

        @Override
        public void run() {
            if (FeatureToggle.isActive((String)"AUTO_RESET_WATCHERS_DISABLED")) {
                return;
            }
            for (Watcher each : this.watchers) {
                if (!each.isTriggered()) continue;
                each.clearTrigger();
            }
        }
    }
}

