/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.polyscope.system.diagnostics.impl.Settings;
import com.ur.util.logging.Log;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final long CHECK_INTERVAL_MS = 100L;
    private long unreasonableDispatchDurationMs = 300L;
    private static int hangCount = 0;
    private static Map<String, Integer> urElementHangCount = new HashMap<String, Integer>();
    private boolean haveShownSomeComponent = false;
    private final LinkedList<DispatchInfo> dispatches = new LinkedList();

    public EventDispatchThreadHangMonitor() {
        this.unreasonableDispatchDurationMs = Settings.getUIResponsivenessMonitorThreshold();
        this.initTimer();
    }

    private void initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
        long period = 60000L;
        Timer timer2 = new Timer("EventDispatchThreadHangCountWriter", true);
        timer2.schedule((TimerTask)new HangCountFileLogger(), period, period);
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        try {
            this.preDispatchEvent();
            super.dispatchEvent(event);
        }
        finally {
            this.postDispatchEvent();
            if (!this.haveShownSomeComponent && event instanceof WindowEvent && event.getID() == 200) {
                this.haveShownSomeComponent = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            this.dispatches.addLast(new DispatchInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void postDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            DispatchInfo justFinishedDispatch = this.dispatches.removeLast();
            justFinishedDispatch.dispose(this.unreasonableDispatchDurationMs);
            Thread currentEventDispatchThread = Thread.currentThread();
            for (DispatchInfo dispatchInfo : this.dispatches) {
                if (dispatchInfo.eventDispatchThread != currentEventDispatchThread) continue;
                dispatchInfo.lastDispatchTimeMillis = System.currentTimeMillis();
            }
        }
    }

    private static void checkForDeadlock() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findMonitorDeadlockedThreads();
        if (threadIds == null) {
            return;
        }
        Log.warning((String)"deadlock detected involving the following threads:");
        for (ThreadInfo info : threadInfos = threadBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
            Log.warning((String)("Thread #" + info.getThreadId() + " " + info.getThreadName() + " (" + (Object)((Object)info.getThreadState()) + ") waiting on " + info.getLockName() + " held by " + info.getLockOwnerName() + EventDispatchThreadHangMonitor.stackTraceToString(info.getStackTrace())));
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder result = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace) {
            String indentation = "    ";
            result.append("\n" + indentation + stackTraceElement);
        }
        return result.toString();
    }

    private static synchronized int getNewHangNumber() {
        return ++hangCount;
    }

    private static boolean isUsableURClassname(StackTraceElement ste) {
        String cn = ste.getClassName();
        if (cn.startsWith("com.ur")) {
            return !cn.startsWith("com.ur.util");
        }
        return cn.startsWith("gui.");
    }

    private static String getURStackTraceKey(StackTraceElement[] stackTraceElement) {
        String bitOfUrelement = "";
        int hashCode = 0;
        for (StackTraceElement s : stackTraceElement) {
            if (!EventDispatchThreadHangMonitor.isUsableURClassname(s)) continue;
            if (bitOfUrelement.isEmpty()) {
                bitOfUrelement = s.getClassName().substring(s.getClassName().lastIndexOf(46) + 1) + "." + s.getMethodName();
            }
            hashCode += s.hashCode();
        }
        return bitOfUrelement + "-" + hashCode;
    }

    private static synchronized int getNewURStackTraceElementMetric(String urStackTraceKey, long factorStuck) {
        int count = urElementHangCount.containsKey(urStackTraceKey) ? urElementHangCount.get(urStackTraceKey) : 0;
        count = (int)((long)count + factorStuck);
        urElementHangCount.put(urStackTraceKey, count);
        return count;
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = EventDispatchThreadHangMonitor.this.dispatches;
            synchronized (linkedList) {
                if (EventDispatchThreadHangMonitor.this.dispatches.isEmpty() || !EventDispatchThreadHangMonitor.this.haveShownSomeComponent) {
                    return;
                }
                ((DispatchInfo)EventDispatchThreadHangMonitor.this.dispatches.getLast()).checkForHang(EventDispatchThreadHangMonitor.this.unreasonableDispatchDurationMs);
            }
        }
    }

    private class HangCountFileLogger
    extends TimerTask {
        private int lastTotalHangs = 0;

        private HangCountFileLogger() {
        }

        private int getTotalHangs() {
            int total = 0;
            for (Integer i : urElementHangCount.values()) {
                total += i.intValue();
            }
            return total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int totalHangs = this.getTotalHangs();
            if (this.lastTotalHangs != totalHangs) {
                this.lastTotalHangs = totalHangs;
                ArrayList hangIdList = new ArrayList();
                ArrayList hangCountList = new ArrayList();
                for (Map.Entry entry : urElementHangCount.entrySet()) {
                    hangIdList.add(entry.getKey());
                    hangCountList.add(entry.getValue());
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(Settings.getUIResponsivenessMonitorOutputFile(), false);
                    writer.append(StringUtils.join(hangIdList, (String)",") + "\n");
                    writer.append(StringUtils.join(hangCountList, (String)","));
                    writer.close();
                }
                catch (IOException ex) {
                    try {
                        Log.error((String)"Could not write file");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Writer)writer);
                }
                IOUtils.closeQuietly((Writer)writer);
            }
        }
    }

    private static class DispatchInfo {
        private StackTraceElement[] lastReportedStack;
        private int hangNumber;
        private final Thread eventDispatchThread = Thread.currentThread();
        private long lastDispatchTimeMillis = System.currentTimeMillis();

        public void checkForHang(long unreasonableDispatchDurationMs) {
            if (this.timeSoFar() > unreasonableDispatchDurationMs) {
                this.examineHang();
            }
        }

        private boolean stackTraceElementIs(StackTraceElement e, String className, String methodName, boolean isNative) {
            return e.getClassName().equals(className) && e.getMethodName().equals(methodName) && e.isNativeMethod() == isNative;
        }

        private boolean isWaitingForNextEvent(StackTraceElement[] currentStack) {
            return this.stackTraceElementIs(currentStack[0], "java.lang.Object", "wait", true) && this.stackTraceElementIs(currentStack[1], "java.lang.Object", "wait", false) && this.stackTraceElementIs(currentStack[2], "java.awt.EventQueue", "getNextEvent", false);
        }

        private void examineHang() {
            StackTraceElement[] currentStack = this.eventDispatchThread.getStackTrace();
            if (this.isWaitingForNextEvent(currentStack)) {
                return;
            }
            if (this.stacksEqual(this.lastReportedStack, currentStack)) {
                return;
            }
            this.hangNumber = EventDispatchThreadHangMonitor.getNewHangNumber();
            String stackTrace = EventDispatchThreadHangMonitor.stackTraceToString(currentStack);
            this.lastReportedStack = currentStack;
            String stackTraceKey = EventDispatchThreadHangMonitor.getURStackTraceKey(currentStack);
            Log.warning((String)("(Hang #" + this.hangNumber + ". Hang id " + stackTraceKey + ") event dispatch thread stuck processing event for " + this.timeSoFar() + " ms:" + stackTrace));
            EventDispatchThreadHangMonitor.checkForDeadlock();
        }

        private boolean stacksEqual(StackTraceElement[] a, StackTraceElement[] b) {
            if (a == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.lastDispatchTimeMillis;
        }

        public void dispose(long unreasonableDispatchDurationMs) {
            if (this.lastReportedStack != null) {
                long timeSoFar = this.timeSoFar();
                String stackTraceKey = EventDispatchThreadHangMonitor.getURStackTraceKey(this.lastReportedStack);
                long factorStuck = timeSoFar / unreasonableDispatchDurationMs;
                int stackTraceKeyMetric = EventDispatchThreadHangMonitor.getNewURStackTraceElementMetric(stackTraceKey, factorStuck);
                Log.warning((String)("(Hang #" + this.hangNumber + ") event dispatch thread unstuck after " + timeSoFar + " ms. Hang id " + stackTraceKey + ". Hang id metric " + stackTraceKeyMetric));
            }
        }
    }
}

