/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.event.EventNotificationService;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FailureReport {
    private static final Logger LOG = LogFactory.createLogger(FailureReport.class);
    public static final String EVENT_LISTENERS_DUMP_FILE = "event-listeners";
    public static final String URGUI_THREAD_DUMP_FILE = "threads";
    public static final String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss.SSS";
    private final String prefixName;
    private final DateFormat dateFormat;

    public FailureReport(Class<?> clazz) {
        this.prefixName = clazz.getSimpleName();
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT);
    }

    void create() {
        this.tryPerformThreadDump();
    }

    private void tryPerformThreadDump() {
        try {
            this.performThreadDump();
        }
        catch (IOException | RuntimeException re) {
            LOG.error("Failed to create thread dump, caught exception " + re.getMessage(), new Object[0]);
        }
    }

    private void performThreadDump() throws IOException {
        Date date = new Date();
        String niceTimeStamp = date.toString();
        String threadDump = this.dumpThreads(niceTimeStamp);
        String listenersDump = niceTimeStamp + "\n" + EventNotificationService.dumpListeners();
        this.writeContentsToFile(threadDump, URGUI_THREAD_DUMP_FILE, date);
        this.writeContentsToFile(listenersDump, EVENT_LISTENERS_DUMP_FILE, date);
    }

    private void writeContentsToFile(String content, String fileName, Date date) throws IOException {
        String timestamp = this.dateFormat.format(date);
        FileUtils.writeToFile((String)content, (File)File.createTempFile(this.prefixName + "-" + timestamp + "-" + fileName + "-", ".log"));
    }

    private String dumpThreads(String header) {
        String result = header + "\n";
        for (Thread each : Thread.getAllStackTraces().keySet()) {
            result = result + this.getStackTrace(each);
        }
        return result;
    }

    public String getStackTraceForSwingThread() {
        for (Thread each : Thread.getAllStackTraces().keySet()) {
            if (!each.getName().contains("AWT-EventQueue")) continue;
            return this.getStackTrace(each);
        }
        return "Thread not Found: AWT-EventQueue";
    }

    private String getStackTrace(Thread thread) {
        String result = "\n[" + thread.getName() + "]\n  java.lang.Thread.State: " + thread.getState().name() + "\n";
        for (StackTraceElement each : thread.getStackTrace()) {
            result = result + "    " + each.getClassName() + "." + each.getMethodName() + "(" + each.getFileName() + ":" + each.getLineNumber() + ")\n";
        }
        return result;
    }

    public String indentEachLine(String indentation, String textToPad) {
        String result = "";
        for (String each : textToPad.split("\n")) {
            result = result + indentation + each + "\n";
        }
        return result;
    }

    public static String getReportFolderPath() {
        return System.getProperty("java.io.tmpdir");
    }
}

