/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.util.NiceProperties;
import com.ur.util.logging.Log;

public class Settings {
    private static final String WARNING_MESSAGE = "Using FastTest_Watcher which will monitor threshold more rapidly";
    private static final String FAST_TEST_WATCHER = "FastTest_Watcher";
    private static WriteableModuleSettings moduleSetting = new WriteableModuleSettings("diagnostics.properties");

    private Settings() {
    }

    private static NiceProperties getProperties() {
        return moduleSetting.properties();
    }

    public static void registerFeatureToggle() {
        if (FeatureToggle.isFeatureDefined((String)FAST_TEST_WATCHER)) {
            return;
        }
        Settings.setFeatureStateFromPropertiesFile();
    }

    private static void setFeatureStateFromPropertiesFile() {
        if (moduleSetting.properties().getBoolean(FAST_TEST_WATCHER, false)) {
            FeatureToggle.activateFeature((String)FAST_TEST_WATCHER);
        } else {
            FeatureToggle.deactivateFeature((String)FAST_TEST_WATCHER);
        }
    }

    public static int getUIBlockedInSeconds() {
        Settings.registerFeatureToggle();
        if (FeatureToggle.isActive((String)FAST_TEST_WATCHER)) {
            Log.warning((String)"Using FastTest_Watcher which will report blocking Swing Threads more readily");
            return 5;
        }
        return Settings.getProperties().getInteger("uiBlockedCheckedInSecondsEvery", 60);
    }

    public static int getHeapThresholdTimeInSeconds() {
        Settings.registerFeatureToggle();
        if (FeatureToggle.isActive((String)FAST_TEST_WATCHER)) {
            Log.warning((String)WARNING_MESSAGE);
            return 1;
        }
        return Settings.getProperties().getInteger("heapThresholdCheckInSecondsEvery", 60);
    }

    public static double getHeapThresholdPercentage() {
        Settings.registerFeatureToggle();
        if (FeatureToggle.isActive((String)FAST_TEST_WATCHER)) {
            Log.warning((String)WARNING_MESSAGE);
            return 1.0;
        }
        return 95.0;
    }

    public static double getHeapThresholdPercentageWarning() {
        Settings.registerFeatureToggle();
        if (FeatureToggle.isActive((String)FAST_TEST_WATCHER)) {
            Log.warning((String)WARNING_MESSAGE);
            return 1.0;
        }
        return 98.0;
    }

    public static boolean isFailureReportDisabled() {
        return Settings.getProperties().getBoolean("failureReportDisabled", false);
    }

    public static int getFailureReportTimeInSeconds() {
        return Settings.getProperties().getInteger("generateFailureReportInSecondsEvery", 3600);
    }

    public static boolean enableLockableUI() {
        return Settings.getProperties().getBoolean("allow.ui.lock", false);
    }

    public static boolean getUIResponsivenessMonitorEnabled() {
        return Settings.getProperties().getBoolean("uiResponsivenessMonitorEnabled", false);
    }

    public static long getUIResponsivenessMonitorThreshold() {
        return Settings.getProperties().getLong("uiResponsivenessMonitorThreshold", 300L);
    }

    public static String getUIResponsivenessMonitorOutputFile() {
        return Settings.getProperties().getProperty("uiResponsivenessMonitorOutputFile", "hang_count.csv");
    }
}

