/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.system.diagnostics.Watcher;
import com.ur.polyscope.system.diagnostics.impl.FailureReport;
import com.ur.polyscope.system.diagnostics.impl.SetTrigger;
import com.ur.polyscope.system.diagnostics.impl.Settings;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public abstract class ThreadedWatcher
implements Watcher,
SetTrigger {
    private static final Logger LOG = LogFactory.createLogger(ThreadedWatcher.class);
    private Timer timer;
    private final long timeInMillis;
    private final FailureReport failureReport;
    private boolean triggered;
    private long nextFailureReportTimeInMilliSeconds;
    private final boolean isFailureReportDisabled;
    private final long failureReportTimeInMilliSeconds;

    protected ThreadedWatcher(int time, TimeUnit unit) {
        this.timeInMillis = unit.toMillis(time);
        this.failureReport = new FailureReport(this.getClass());
        this.isFailureReportDisabled = Settings.isFailureReportDisabled();
        this.failureReportTimeInMilliSeconds = (long)Settings.getFailureReportTimeInSeconds() * 1000L;
        this.nextFailureReportTimeInMilliSeconds = System.currentTimeMillis() - this.failureReportTimeInMilliSeconds;
    }

    public void start() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.getProbe(this), this.timeInMillis, this.timeInMillis);
    }

    protected abstract TimerTask getProbe(ThreadedWatcher var1);

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public boolean isStopped() {
        return this.timer == null;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void clearTrigger() {
        this.triggered = false;
        this.start();
    }

    @Override
    public void triggerInfo(String message, Object ... values) {
        LOG.info(String.format(message, values), new Object[0]);
        this.tryStop();
    }

    @Override
    public void triggerWarning(String message, Object ... values) {
        LOG.warn(String.format(message, values), new Object[0]);
        this.tryStop();
    }

    private void tryStop() {
        try {
            this.stop();
            if (!this.isFailureReportDisabled && this.nextFailureReportTimeInMilliSeconds < System.currentTimeMillis()) {
                this.failureReport.create();
                this.nextFailureReportTimeInMilliSeconds = System.currentTimeMillis() + this.failureReportTimeInMilliSeconds;
            }
        }
        finally {
            this.triggered = true;
        }
    }
}

