/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.system.diagnostics.impl.FailureReport;
import com.ur.polyscope.system.diagnostics.impl.SetTrigger;
import com.ur.polyscope.system.diagnostics.impl.Settings;
import com.ur.polyscope.system.diagnostics.impl.ThreadedWatcher;
import com.ur.swing.SwingUtil;
import java.util.TimerTask;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class UIBlockedWatcher
extends ThreadedWatcher {
    private static final Logger LOG = LogFactory.createLogger(UIBlockedWatcher.class);
    private static boolean uiStillBlocked;

    @Inject
    public UIBlockedWatcher() {
        super(Settings.getUIBlockedInSeconds(), TimeUnit.SECONDS);
        uiStillBlocked = false;
    }

    public UIBlockedWatcher(int time, TimeUnit unit) {
        super(time, unit);
    }

    @Override
    protected TimerTask getProbe(ThreadedWatcher threadedWatcher) {
        return new ProbeUIThread(this);
    }

    private static class ExecutionProbe
    implements Runnable {
        private ExecutionProbe() {
        }

        @Override
        public void run() {
            LOG.debug("Probing UI Thread", new Object[0]);
        }
    }

    private static class ProbeUIThread
    extends TimerTask {
        private final SetTrigger setTrigger;
        FutureTask<Runnable> futureProbe = ProbeUIThread.createNextProbe();

        public ProbeUIThread(SetTrigger setTrigger) {
            this.setTrigger = setTrigger;
            LOG.info("Started Swing Probe", new Object[0]);
        }

        @Override
        public void run() {
            if (this.futureProbe.isDone()) {
                uiStillBlocked = false;
                this.futureProbe = ProbeUIThread.createNextProbe();
            } else if (!uiStillBlocked) {
                uiStillBlocked = true;
                this.setTrigger.triggerWarning("UI has been blocked\n: %s", this.awtStackTrace());
            } else {
                LOG.debug("UI still locked", new Object[0]);
            }
        }

        private static FutureTask<Runnable> createNextProbe() {
            return SwingUtil.invokeLater((Runnable)new ExecutionProbe());
        }

        private String awtStackTrace() {
            FailureReport report = new FailureReport(this.getClass());
            return report.indentEachLine("    ", report.getStackTraceForSwingThread().trim());
        }
    }
}

