/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.flightrecorder;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.system.diagnostics.impl.FailureReport;
import com.ur.polyscope.system.diagnostics.impl.UIBlockedWatcher;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class GuiDiagnosticsProbe
implements FlightRecorderProbe {
    private static final String TARGET_DEBUG_LOGS_FOLDER_NAME = "gui-diagnostics";
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public GuiDiagnosticsProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    public String getName() {
        return "GUI Diagnostics";
    }

    public void write(PrintStream printStream) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        this.addLogFilesForClass(r, UIBlockedWatcher.class);
        return r.asList();
    }

    private void addLogFilesForClass(AttachmentCollector collector, final Class<?> clazz) {
        File[] f = new File(FailureReport.getReportFolderPath()).listFiles();
        if (f != null) {
            Collection logFiles = Collections2.filter(Arrays.asList(f), (Predicate)new Predicate<File>(){

                public boolean apply(File file) {
                    return file.isFile() && file.getName().startsWith(clazz.getSimpleName());
                }
            });
            for (File eachFile : logFiles) {
                collector.collect(eachFile, TARGET_DEBUG_LOGS_FOLDER_NAME, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

