/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.NiceProperties;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;

public class HeapDumpGenerator {
    private static final String HEAP_DUMP_LIVE = "heapDumpLive";
    private static final Logger LOG = LogFactory.createLogger(HeapDumpGenerator.class);
    private static final int MAX_HEAP_DUMPS = 2;
    private static final String HEAP_FILE_EXTENSION = ".hprof";
    private final AtomicReference<Instant> lastGenerated = new AtomicReference<Object>(null);
    private final Path heapDumpPath;
    private final String prefixName;
    private final Duration timeBetweenHeapDumps;
    private final HotSpotDiagnosticMXBean diagnosticMXBean;

    public HeapDumpGenerator(Path heapDumpPath, String prefixName, Duration timeBetweenHeapDumps) {
        this(ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class), heapDumpPath, prefixName, timeBetweenHeapDumps);
    }

    HeapDumpGenerator(HotSpotDiagnosticMXBean diagnosticMXBean, Path heapDumpPath, String prefixName, Duration timeBetweenHeapDumps) {
        this.heapDumpPath = heapDumpPath;
        this.prefixName = prefixName;
        this.timeBetweenHeapDumps = timeBetweenHeapDumps;
        this.diagnosticMXBean = diagnosticMXBean;
    }

    public void execute() {
        if (this.allowToGenerate()) {
            this.removeOldHeapDumps();
            this.generateHeapDump();
        }
    }

    private boolean allowToGenerate() {
        Instant lastGeneratedAt = this.lastGenerated.get();
        if (lastGeneratedAt == null) {
            this.lastGenerated.set(Instant.now());
            return true;
        }
        return this.isEnoughTimeSinceLastHeapDump(lastGeneratedAt);
    }

    private boolean isEnoughTimeSinceLastHeapDump(Instant lastGeneratedAt) {
        Instant heapDumpTimeThrottle = Instant.now().minus(this.timeBetweenHeapDumps);
        if (lastGeneratedAt.isBefore(heapDumpTimeThrottle)) {
            this.lastGenerated.set(Instant.now());
            return true;
        }
        return false;
    }

    private void generateHeapDump() {
        Path filePath = this.generateFileName(this.prefixName);
        Thread heapDumpThread = new Thread(() -> {
            try {
                this.diagnosticMXBean.dumpHeap(filePath.toString(), HeapDumpGenerator.isHeapDumpLive());
                LOG.warn("Heap dump generated at: " + filePath, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Error occurred while generating heap dump: " + e.getMessage(), new Object[0]);
            }
        }, "HeapDumper");
        heapDumpThread.setPriority(10);
        heapDumpThread.start();
    }

    private void removeOldHeapDumps() {
        File homeDir = this.heapDumpPath.toFile();
        File[] files = homeDir.listFiles((dir, name) -> name.contains(this.prefixName) && name.endsWith(HEAP_FILE_EXTENSION));
        if (files != null && files.length > 1) {
            File[] lastModified = HeapDumpGenerator.sortFilesByLastModifiedAsc(files);
            this.deleteOldFiles(lastModified);
        }
    }

    private void deleteOldFiles(File[] files) {
        int filesToDelete = files.length - 1;
        for (int i = 0; i < filesToDelete; ++i) {
            try {
                Path filePath = files[i].toPath();
                Files.delete(filePath);
                LOG.warn("Deleted old heap dump file: " + files[i].getName(), new Object[0]);
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to delete old heap dump file: " + files[i].getName() + " - " + e.getMessage(), new Object[0]);
            }
        }
    }

    private static File[] sortFilesByLastModifiedAsc(File[] files) {
        File[] sortedFiles = (File[])files.clone();
        Arrays.sort(sortedFiles, Comparator.comparingLong(File::lastModified));
        return sortedFiles;
    }

    private Path generateFileName(String prefixName) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        String timestamp = formatter.format(Instant.now().atZone(ZoneOffset.UTC));
        return this.heapDumpPath.resolve(prefixName + "_" + timestamp + HEAP_FILE_EXTENSION);
    }

    private static NiceProperties getDiagnosticsProperties() {
        return new WriteableModuleSettings("diagnostics.properties").properties();
    }

    private static boolean isHeapDumpLive() {
        return HeapDumpGenerator.getDiagnosticsProperties().getBoolean(HEAP_DUMP_LIVE, true);
    }
}

