/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.system.diagnostics.impl.SetTrigger;
import com.ur.polyscope.system.diagnostics.impl.Settings;
import com.ur.polyscope.system.diagnostics.impl.ThreadedWatcher;
import com.ur.polyscope.system.diagnostics.impl.profile.PolyscopeMemoryUsage;
import com.ur.polyscope.system.diagnostics.impl.profile.Profiling;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class HeapThresholdWatcher
extends ThreadedWatcher {
    private static final Logger LOG = LogFactory.createLogger(HeapThresholdWatcher.class);
    private static double heapThresholdPercentage;
    private static double heapThresholdPercentageWarning;
    private final Profiling profiling;

    @Inject
    public HeapThresholdWatcher(Profiling profiling) {
        this(profiling, Settings.getHeapThresholdTimeInSeconds(), TimeUnit.SECONDS);
    }

    public HeapThresholdWatcher(Profiling profiling, int time, TimeUnit unit) {
        super(time, unit);
        this.profiling = profiling;
        heapThresholdPercentage = Settings.getHeapThresholdPercentage();
        heapThresholdPercentageWarning = Settings.getHeapThresholdPercentageWarning();
    }

    @Override
    protected TimerTask getProbe(ThreadedWatcher threadedWatcher) {
        return new ProbeUIThread(this, this.profiling);
    }

    private static class ProbeUIThread
    extends TimerTask {
        private final SetTrigger setTrigger;
        private final Profiling profiling;

        public ProbeUIThread(SetTrigger setTrigger, Profiling profiling) {
            this.setTrigger = setTrigger;
            this.profiling = profiling;
            LOG.info("Started JavaHeap Probe", new Object[0]);
        }

        @Override
        public void run() {
            PolyscopeMemoryUsage polyscopeMemoryUsage = this.profiling.getPolyscopeMemoryUsage();
            if (polyscopeMemoryUsage.getPercentageMemoryUsed() > heapThresholdPercentage && polyscopeMemoryUsage.getPercentageMemoryUsed() < heapThresholdPercentageWarning) {
                this.setTrigger.triggerInfo("Heap is at %s (%s of %s used)", polyscopeMemoryUsage.getPercentageMemoryUsedFormatted(), polyscopeMemoryUsage.getCurrentUsedMemoryFormatted(), polyscopeMemoryUsage.getMaxHeapSizeFormatted());
            } else if (polyscopeMemoryUsage.getPercentageMemoryUsed() > heapThresholdPercentageWarning) {
                this.setTrigger.triggerWarning("Heap is at %s (%s of %s used)", polyscopeMemoryUsage.getPercentageMemoryUsedFormatted(), polyscopeMemoryUsage.getCurrentUsedMemoryFormatted(), polyscopeMemoryUsage.getMaxHeapSizeFormatted());
            }
        }
    }
}

