/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.system.diagnostics.impl.profile.HeapDumpGenerator;
import com.ur.polyscope.system.diagnostics.impl.profile.PolyscopeMemoryUsage;
import com.ur.polyscope.system.diagnostics.impl.profile.Profiling;
import com.ur.util.NiceProperties;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;

public class HeapUsageWatcher {
    private static final Logger LOG = LogFactory.createLogger(HeapUsageWatcher.class);
    private final Profiling profiling;
    private final HeapDumpGenerator heapDumpGenerator;

    @Inject
    public HeapUsageWatcher(Profiling profiling) {
        this.profiling = profiling;
        this.heapDumpGenerator = new HeapDumpGenerator(Paths.get(System.getProperty("user.home"), new String[0]), "heapUsage", Duration.ofDays(1L));
        this.start();
    }

    public void start() {
        HeapUsageTask heapMonitoring = new HeapUsageTask(this.profiling, this.heapDumpGenerator);
        long heapDumpInterval = HeapUsageWatcher.getHeapDumpInterval();
        LOG.info("Starting heap usage watcher", new Object[0]);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)heapMonitoring, heapDumpInterval, heapDumpInterval);
    }

    private static long getHeapDumpInterval() {
        return HeapUsageWatcher.getDiagnosticsProperties().getLong("heapDumpInterval", 600000L);
    }

    private static NiceProperties getDiagnosticsProperties() {
        return new WriteableModuleSettings("diagnostics.properties").properties();
    }

    private static class HeapUsageTask
    extends TimerTask {
        private final Profiling profiling;
        private final HeapDumpGenerator heapDumpGenerator;

        public HeapUsageTask(Profiling profiling, HeapDumpGenerator heapDumpGenerator) {
            this.profiling = profiling;
            this.heapDumpGenerator = heapDumpGenerator;
        }

        @Override
        public void run() {
            PolyscopeMemoryUsage polyscopeMemoryUsage = this.profiling.getPolyscopeMemoryUsage();
            if (polyscopeMemoryUsage.getPercentageMemoryUsed() >= HeapUsageTask.getHeapThresholdPercentage()) {
                String heapWarning = String.format("Heap is at %s (%s of %s used)", polyscopeMemoryUsage.getPercentageMemoryUsedFormatted(), polyscopeMemoryUsage.getCurrentUsedMemoryFormatted(), polyscopeMemoryUsage.getMaxHeapSizeFormatted());
                LOG.warn(heapWarning, new Object[0]);
                this.heapDumpGenerator.execute();
            }
        }

        private static double getHeapThresholdPercentage() {
            return HeapUsageWatcher.getDiagnosticsProperties().getDouble("heapDumpTrigger", 110.0);
        }
    }
}

