/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import java.text.StringCharacterIterator;

public class PolyscopeMemoryUsage {
    private final long maxHeapSize;
    private final long currentHeapSize;
    private final long currentFreeHeapSize;
    private final long currentUsedMemory;
    private final double percentageMemoryUsed;

    public static PolyscopeMemoryUsage getSnapshot() {
        return new PolyscopeMemoryUsage(Runtime.getRuntime().maxMemory(), Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory());
    }

    protected PolyscopeMemoryUsage(long maxHeapSize, long currentHeapSize, long currentFreeHeapSize) {
        this.maxHeapSize = maxHeapSize;
        this.currentHeapSize = currentHeapSize;
        this.currentFreeHeapSize = currentFreeHeapSize;
        this.currentUsedMemory = currentHeapSize - currentFreeHeapSize;
        this.percentageMemoryUsed = this.calculateMemoryPercentageUsed();
    }

    private double calculateMemoryPercentageUsed() {
        return this.calculateMemoryPercentageUsed(this.currentUsedMemory, this.maxHeapSize);
    }

    private double calculateMemoryPercentageUsed(double usedMem, double maxMem) {
        return usedMem / maxMem * 100.0;
    }

    public String getMaxHeapSizeFormatted() {
        return this.humanReadableByteCountSI(this.maxHeapSize);
    }

    public String getCurrentHeapSizeFormatted() {
        return this.humanReadableByteCountSI(this.currentHeapSize);
    }

    public String getCurrentFreeHeapSizeFormatted() {
        return this.humanReadableByteCountSI(this.currentFreeHeapSize);
    }

    public String getCurrentUsedMemoryFormatted() {
        return this.humanReadableByteCountSI(this.currentUsedMemory);
    }

    public String getPercentageMemoryUsedFormatted() {
        return String.format("%,.2f", this.percentageMemoryUsed);
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public long getCurrentHeapSize() {
        return this.currentHeapSize;
    }

    public long getCurrentFreeHeapSize() {
        return this.currentFreeHeapSize;
    }

    public long getCurrentUsedMemory() {
        return this.currentUsedMemory;
    }

    public double getPercentageMemoryUsed() {
        return this.percentageMemoryUsed;
    }

    private String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }
}

