/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.lang.StringUtils;
import com.ur.polyscope.system.diagnostics.impl.profile.Profiling;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class ProfileDashBoardAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser PROFILE = new ScriptActionDefinitionParser("profile [-c]");
    private static final ScriptActionDefinitionParser PROFILING_DAEMON = new ScriptActionDefinitionParser("profile [-c] -d <rest>");
    private final Profiling profiling;

    @Inject
    public ProfileDashBoardAction(Profiling profiling) {
        this.profiling = profiling;
    }

    public boolean canHandleMessage(String input) {
        return PROFILE.isMatch(input) || PROFILING_DAEMON.isMatch(input);
    }

    public String execute(String input) {
        boolean csvOutput = PROFILING_DAEMON.hasOption("-c", input);
        if (PROFILING_DAEMON.isMatch(input)) {
            String daemonList = PROFILING_DAEMON.getArgument(0, input);
            return this.profiling.profileDaemons(StringUtils.divide((String)" ", (String)daemonList), csvOutput);
        }
        return this.profiling.asString(csvOutput);
    }
}

