/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.monitor.RobotState;
import com.ur.polyscope.system.diagnostics.impl.profile.PolyscopeMemoryUsage;
import com.ur.polyscope.system.diagnostics.impl.profile.TopCommandHelper;
import com.ur.polyscope.system.diagnostics.impl.profile.TopCommandParser;
import com.ur.util.event.EventNotificationService;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Singleton;
import org.jsoup.helper.StringUtil;

@Singleton
public class Profiling {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private int threadCount;
    private double memoryUsagePolyScopeFromTopCommand;
    private double memoryUsageControllerFromTopCommand;
    private PolyscopeMemoryUsage polyscopeMemoryUsage;
    private int listeners;
    private int unhandledMessages;

    private void extractDataFromActiveProcesses() {
        this.memoryUsagePolyScopeFromTopCommand = this.getPolyscopeMemoryFromTop();
        this.memoryUsageControllerFromTopCommand = this.getControllerMemoryFromTop();
        this.threadCount = ManagementFactory.getThreadMXBean().getThreadCount();
        this.polyscopeMemoryUsage = this.getPolyscopeMemoryUsage();
        this.listeners = EventNotificationService.listenerCount();
        this.unhandledMessages = RobotState.getUnhandledEventsCount();
    }

    protected PolyscopeMemoryUsage getPolyscopeMemoryUsage() {
        return PolyscopeMemoryUsage.getSnapshot();
    }

    private double getControllerMemoryFromTop() {
        String consoleOutput = TopCommandHelper.getConsoleOutputForControllerMemory();
        return TopCommandParser.averageMemory(consoleOutput);
    }

    private double getPolyscopeMemoryFromTop() {
        String consoleOutput = TopCommandHelper.getConsoleOutputForPolyscopeMemory();
        return TopCommandParser.averageMemory(consoleOutput);
    }

    public String asString(boolean csvOutput) {
        this.extractDataFromActiveProcesses();
        return csvOutput ? this.toCSV() : this.toHumanReadable();
    }

    private String toHumanReadable() {
        return this.output("Time: %s, Thr: %s, Mem(java): %s, Mem(poly): %s/%s/%s/%s, Lstns: %s, Msg: %s, Mem(ctrl): %s");
    }

    private String toCSV() {
        return this.output("%s, %s, %s, %s, %s, %s, %s, %s, %s ,%s");
    }

    private String output(String format) {
        return String.format(format, this.dateFormat.format(new Date()), this.threadCount, this.memoryUsagePolyScopeFromTopCommand, this.polyscopeMemoryUsage.getPercentageMemoryUsedFormatted(), this.polyscopeMemoryUsage.getCurrentUsedMemoryFormatted(), this.polyscopeMemoryUsage.getCurrentHeapSizeFormatted(), this.polyscopeMemoryUsage.getMaxHeapSizeFormatted(), this.listeners, this.unhandledMessages, this.memoryUsageControllerFromTopCommand);
    }

    public String profileDaemons(String[] daemons, boolean csvOutput) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.dateFormat.format(new Date()));
        for (DaemonProfile daemonProfile : this.doDaemonProfiling(daemons)) {
            values.add(csvOutput ? daemonProfile.toCSV() : daemonProfile.toString());
        }
        return StringUtil.join(values, (String)(csvOutput ? "," : "\n"));
    }

    private List<DaemonProfile> doDaemonProfiling(String[] daemons) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        final List<DaemonProfile> daemonProfiles = Collections.synchronizedList(new ArrayList());
        int i = 0;
        for (final String daemon : daemons) {
            final Integer ordering = ++i;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    String pid = TopCommandHelper.getDaemonPid(daemon);
                    if (!pid.isEmpty()) {
                        String top = TopCommandHelper.getConsoleOutputForPid(pid);
                        double mem = TopCommandParser.averageMemory(top);
                        daemonProfiles.add(new DaemonProfile(ordering, daemon, mem));
                    } else {
                        daemonProfiles.add(new DaemonProfile(ordering, daemon + " not found", -1.0));
                    }
                }
            });
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Collections.sort(daemonProfiles);
        return daemonProfiles;
    }

    private static class DaemonProfile
    implements Comparable {
        private double mem;
        private final Integer ordering;
        private String daemon;

        public DaemonProfile(Integer ordering, String daemon, double mem) {
            this.ordering = ordering;
            this.daemon = daemon;
            this.mem = mem;
        }

        public String toString() {
            return String.format("%-12s: MEM:%4.1f", this.daemon, this.mem);
        }

        public String toCSV() {
            return String.format("%s,%s,%s", this.daemon, this.mem);
        }

        public int compareTo(Object o) {
            return this.ordering.compareTo(((DaemonProfile)o).ordering);
        }
    }
}

