/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.lang.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;

public class TopCommandHelper {
    private static final String POLYSCOPE_PID_COMMAND = "ps aux | grep felix | grep -v grep | grep -v felix-cache | awk '{print $2}'";
    private static final String CONTROLLER_PID_COMMAND = "ps aux | grep URControl | grep -v grep | awk '{print $2}'";

    public static String getConsoleOutputForPolyscopeMemory() {
        return TopCommandHelper.getConsoleOutputForPid(TopCommandHelper.getPolyscopePid());
    }

    public static String getConsoleOutputForControllerMemory() {
        return TopCommandHelper.getConsoleOutputForPid(TopCommandHelper.getControllerPid());
    }

    public static String getConsoleOutputForPid(String pid) {
        String topCommand = TopCommandHelper.getTopCommand(pid);
        return TopCommandHelper.tryToExecuteCommand(topCommand);
    }

    public static String getDaemonPid(String daemon) {
        return TopCommandHelper.tryToExecuteCommand("/bin/sh", "-c", "ps aux | grep " + daemon + " | grep -v grep | grep -v bash | awk '{print $2}'").replace("\n", "");
    }

    private static String getPolyscopePid() {
        return TopCommandHelper.tryToExecuteCommand("/bin/sh", "-c", POLYSCOPE_PID_COMMAND).replace("\n", "");
    }

    private static String getControllerPid() {
        return TopCommandHelper.tryToExecuteCommand("/bin/sh", "-c", CONTROLLER_PID_COMMAND).replace("\n", "");
    }

    private static String getTopCommand(String pid) {
        return "top -p " + pid + " -b -n 5 -d 0.2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String tryToExecuteCommand(String ... command) {
        Process process = null;
        BufferedReader input = null;
        String result = "";
        try {
            process = command.length == 1 ? Runtime.getRuntime().exec(command[0]) : Runtime.getRuntime().exec(command);
            input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            result = TopCommandHelper.getAllLines(input);
        }
        catch (IOException iOException) {
            IOUtil.close(input);
            IOUtil.close(process);
            catch (Throwable throwable) {
                IOUtil.close(input);
                IOUtil.close(process);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)input);
        IOUtil.close((Process)process);
        return result;
    }

    private static String getAllLines(BufferedReader input) throws IOException {
        String line;
        String result = "";
        while ((line = input.readLine()) != null) {
            result = result + line + "\n";
        }
        return result;
    }
}

