/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.diagnostics.impl.profile;

import com.ur.lang.PrimitiveUtils;
import java.util.ArrayList;
import java.util.List;

public class TopCommandParser {
    public static double averageMemory(String topOutput) {
        return TopCommandParser.averageValue(topOutput, 10);
    }

    private static double averageValue(String top, int field) {
        List<String> values = TopCommandParser.parseTop(top, field);
        if (values.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (String value : values) {
            sum += PrimitiveUtils.parseDouble((String)value, (double)0.0);
        }
        return sum / (double)values.size();
    }

    private static List<String> parseTop(String top, int field) {
        ArrayList<String> result = new ArrayList<String>();
        int headerLineIndex = top.indexOf("%CPU");
        while (headerLineIndex >= 0) {
            String headerLine = top.substring(headerLineIndex);
            int valueLineIndex = headerLine.indexOf("\n");
            if (valueLineIndex >= 0) {
                String valueLine = headerLine.substring(valueLineIndex + 1);
                int endIndex = valueLine.indexOf("\n");
                if (endIndex < 0) {
                    endIndex = valueLine.length();
                }
                valueLine = valueLine.substring(0, endIndex).trim();
                String[] split = valueLine.split(" ");
                int fieldCounter = 0;
                for (String s : split) {
                    if ("".equals(s) || ++fieldCounter != field) continue;
                    result.add(s);
                    break;
                }
            }
            headerLineIndex = top.indexOf("%CPU", headerLineIndex + 1);
        }
        return result;
    }
}

