/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.impl;

import com.ur.monitor.ModelSource;
import com.ur.monitor.Source;
import com.ur.monitor.StreamedModel;
import com.ur.polyscope.program.ProgramHolder;
import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.monitor.ProgramInfo;
import com.ur.polyscope.program.monitor.ProgramState;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
@Source(value=ProgramInfo.class)
class ProgramInfoModelSource
extends ModelSource<ProgramInfo> {
    private final Provider<ProgramHolder> programHolderProvider;
    private final Provider<ProgramStateHolder> programStateHolderProvider;
    private ProgramHolder programHolder;
    private ProgramStateHolder programStateHolder;

    @Inject
    public ProgramInfoModelSource(Provider<ProgramHolder> programHolderProvider, Provider<ProgramStateHolder> programStateHolderProvider) {
        super((StreamedModel)new ProgramInfo(null, ProgramState.STOPPED));
        this.programHolderProvider = programHolderProvider;
        this.programStateHolderProvider = programStateHolderProvider;
    }

    void emit() {
        this.initHoldersIfNeeded();
        this.broadcaster.next((Object)new ProgramInfo(this.programHolder.getProgram(), this.programStateHolder.getProgramState()));
    }

    private void initHoldersIfNeeded() {
        if (this.programHolder == null) {
            this.programHolder = (ProgramHolder)this.programHolderProvider.get();
        }
        if (this.programStateHolder == null) {
            this.programStateHolder = (ProgramStateHolder)this.programStateHolderProvider.get();
        }
    }
}

