/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.impl.tree;

import com.ur.polyscope.program.tree.Rescheduler;
import com.ur.swing.SwingUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ReschedulerImpl
implements Rescheduler {
    private ScheduledExecutorService scheduler = this.createScheduler();
    private final Map<Object, Long> lastExecutionTimeMap = new HashMap<Object, Long>();
    private final Map<Object, ScheduledFuture<?>> scheduledTaskMap = new HashMap();
    private final Map<Object, ScheduledFuture<?>> cleanUpMaps = new HashMap();
    private long periode = 150L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public void setPeriode(long periode, TimeUnit timeUnit) {
        this.periode = periode;
        this.timeUnit = timeUnit;
    }

    public void execute(final Object id, final Runnable runnable) {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ReschedulerImpl.this.recentlyExecuted(id)) {
                    ReschedulerImpl.this.rescheduleExecution(id, runnable);
                } else {
                    ReschedulerImpl.this.doExecute(id, runnable);
                }
            }
        });
    }

    public void cancelAll() {
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ReschedulerImpl.this.lastExecutionTimeMap.clear();
                ReschedulerImpl.this.scheduledTaskMap.clear();
                ReschedulerImpl.this.cleanUpMaps.clear();
                ReschedulerImpl.this.scheduler.shutdownNow();
            }
        });
    }

    private boolean recentlyExecuted(Object id) {
        long now = System.currentTimeMillis();
        return now - this.getLastExecutionTime(id) < this.timeUnit.toMillis(this.periode);
    }

    private void rescheduleExecution(Object id, Runnable runnable) {
        if (this.alreadyRescheduled(id)) {
            return;
        }
        this.removeLastScheduledExecution(id);
        this.removeDelayedCleanupTask(id);
        this.scheduleExecution(id, runnable);
    }

    private boolean alreadyRescheduled(Object id) {
        return this.scheduledTaskMap.containsKey(id);
    }

    private void doExecute(Object id, Runnable runnable) {
        try {
            try {
                this.registerExecutionTime(id);
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cleanUpTaskLater(id);
            }
        }
        finally {
            this.cleanUpTaskLater(id);
        }
    }

    private void cleanUpTaskLater(final Object id) {
        this.removeDelayedCleanupTask(id);
        Runnable cleanUpMapsTask = new Runnable(){

            @Override
            public void run() {
                SwingUtil.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ReschedulerImpl.this.lastExecutionTimeMap.remove(id);
                        ReschedulerImpl.this.removeLastScheduledExecution(id);
                        ReschedulerImpl.this.removeDelayedCleanupTask(id);
                    }
                });
            }
        };
        ScheduledFuture<?> scheduledRemoveTask = this.getScheduler().schedule(cleanUpMapsTask, this.periode * 2L, this.timeUnit);
        this.cleanUpMaps.put(id, scheduledRemoveTask);
    }

    private void scheduleExecution(final Object id, final Runnable runnable) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                SwingUtil.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ReschedulerImpl.this.doExecute(id, runnable);
                    }
                });
            }
        };
        ScheduledFuture<?> scheduledExecutionTask = this.getScheduler().schedule(task, this.periode, this.timeUnit);
        this.scheduledTaskMap.put(id, scheduledExecutionTask);
    }

    private void registerExecutionTime(Object id) {
        this.lastExecutionTimeMap.put(id, System.currentTimeMillis());
    }

    private long getLastExecutionTime(Object id) {
        Long lastTime = this.lastExecutionTimeMap.get(id);
        if (lastTime == null) {
            return 0L;
        }
        return lastTime;
    }

    private void removeLastScheduledExecution(Object id) {
        ScheduledFuture<?> task = this.scheduledTaskMap.remove(id);
        if (task != null) {
            task.cancel(false);
        }
    }

    private void removeDelayedCleanupTask(Object id) {
        ScheduledFuture<?> cleanUpTask = this.cleanUpMaps.remove(id);
        if (cleanUpTask != null) {
            cleanUpTask.cancel(false);
        }
    }

    private ScheduledExecutorService getScheduler() {
        if (this.scheduler.isShutdown() && !this.scheduler.isTerminated()) {
            try {
                this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }
        if (this.scheduler.isTerminated()) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    private ScheduledExecutorService createScheduler() {
        return Executors.newSingleThreadScheduledExecutor();
    }
}

