/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.internal.ConceptLocationImpl;
import com.ur.polyscope.concept.operations.internal.FileFactory;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.LocationType;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import java.io.File;
import javax.inject.Inject;

public class ConceptLocationFactoryImpl
implements ConceptLocationFactory {
    private final USBDirectoryFilter usbDirectoryFilter;

    @Inject
    public ConceptLocationFactoryImpl(USBDirectoryFilter usbDirectoryFilter) {
        this.usbDirectoryFilter = usbDirectoryFilter;
    }

    public ConceptLocation get(String name, String path, LocationType locationType) {
        return new ConceptLocationImpl(name, path, locationType, this.usbDirectoryFilter);
    }

    public ConceptLocation getUnique(ConceptLocation conceptLocation) {
        String baseName = conceptLocation.getName();
        String path = conceptLocation.getPath();
        LocationType type = conceptLocation.getType();
        int count = 1;
        String uniqueName = ConceptLocationFactoryImpl.getUniqueName(baseName, count);
        File uniqueFile = FileFactory.getFile(uniqueName, path, type);
        while (uniqueFile.exists()) {
            uniqueName = ConceptLocationFactoryImpl.getUniqueName(baseName, ++count);
            uniqueFile = FileFactory.getFile(uniqueName, path, type);
        }
        return this.get(uniqueName, path, type);
    }

    private static String getUniqueName(String baseName, int count) {
        return String.valueOf(baseName) + "_" + count;
    }
}

