/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.google.common.base.Objects;
import com.ur.polyscope.concept.operations.internal.FileFactory;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.LocationType;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import com.ur.util.logging.Log;
import java.io.File;

public class ConceptLocationImpl
extends ConceptLocation {
    private final String name;
    private final String path;
    private final LocationType type;
    private final USBDirectoryFilter usbDirectoryFilter;
    private final File fileLocation;

    public ConceptLocationImpl(String name, String path, LocationType type, USBDirectoryFilter usbDirectoryFilter) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.usbDirectoryFilter = usbDirectoryFilter;
        this.fileLocation = FileFactory.getFile(name, path, type);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isExternalTo(ConceptLocation conceptLocation) {
        boolean thisUsb = this.usbDirectoryFilter.isPathOnUSB(this.fileLocation);
        File otherFile = FileFactory.getFile(conceptLocation);
        boolean otherUsb = this.usbDirectoryFilter.isPathOnUSB(otherFile);
        if (thisUsb && otherUsb) {
            String otherMountPoint;
            String thisMountPoint = this.usbDirectoryFilter.getRootName(this.fileLocation);
            return !thisMountPoint.equals(otherMountPoint = this.usbDirectoryFilter.getRootName(otherFile));
        }
        return thisUsb ^ otherUsb;
    }

    public LocationType getType() {
        return this.type;
    }

    public String getFullPath() {
        try {
            return this.fileLocation.getCanonicalPath();
        }
        catch (Exception e) {
            Log.error((String)"Could not get canonical path", (Throwable)e);
            return this.fileLocation.getAbsolutePath();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean equals(Object o) {
        boolean canonicallyEqual;
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConceptLocation other = (ConceptLocation)o;
        boolean exactlyEqual = this.getName().equals(other.getName()) && this.getPath().equals(other.getPath()) && this.getType().isConcept(other.getType().getConcept());
        boolean bl = canonicallyEqual = this.getFullPath().equals(other.getFullPath()) && this.getType().isConcept(other.getType().getConcept());
        return exactlyEqual || canonicallyEqual;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFullPath(), this.getType().getInstance(), this.getType().getConcept()});
    }
}

