/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.ConceptOperationFactory;
import com.ur.polyscope.concept.operations.UserInputResource;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;

public class ConceptOperationFactoryImpl
implements ConceptOperationFactory {
    public ConceptOperation getCopy(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
        return new CopyOperationImpl(source, dest, input);
    }

    public ConceptOperation getMove(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
        return new MoveOperationImpl(source, dest, input);
    }

    private class CopyOperationImpl
    implements ConceptOperation {
        private final ConceptLocation source;
        private final ConceptLocation dest;
        private final UserInputResource input;

        public CopyOperationImpl(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
            this.source = source;
            this.dest = dest;
            this.input = input;
        }

        public boolean canExecute() {
            boolean canMove;
            boolean fileExists = new File(this.dest.getFullPath()).exists();
            boolean bl = canMove = !this.source.getFullPath().equals(this.dest.getFullPath());
            if (fileExists) {
                return this.input.canOverwriteFileName(this.dest) && canMove;
            }
            return canMove;
        }

        public boolean execute() {
            try {
                File sourceFile = new File(this.source.getFullPath());
                File destFile = new File(this.dest.getFullPath());
                FileUtils.copy((File)sourceFile, (File)destFile);
                return destFile.exists();
            }
            catch (IOException e) {
                Log.error((String)"Cannot paste file: ", (Throwable)e);
                return false;
            }
        }

        public String getError() {
            return "Unable to complete copy operation from " + this.source.getFullPath() + " to " + this.dest.getFullPath();
        }
    }

    private class MoveOperationImpl
    implements ConceptOperation {
        private final ConceptLocation source;
        private final ConceptLocation dest;
        private final UserInputResource input;

        public MoveOperationImpl(ConceptLocation source, ConceptLocation dest, UserInputResource input) {
            this.source = source;
            this.dest = dest;
            this.input = input;
        }

        public boolean canExecute() {
            boolean fileExists = new File(this.dest.getFullPath()).exists();
            boolean canMove = new File(this.source.getFullPath()).exists();
            if (fileExists) {
                return this.input.canOverwriteFileName(this.dest) && canMove;
            }
            return canMove;
        }

        public boolean execute() {
            try {
                File sourceFile = new File(this.source.getFullPath());
                File destFile = new File(this.dest.getFullPath());
                FileUtils.copy((File)sourceFile, (File)destFile);
                return sourceFile.delete();
            }
            catch (IOException e) {
                Log.error((String)"Cannot paste file: ", (Throwable)e);
                return false;
            }
        }

        public String getError() {
            return "Unable to complete move operation from " + this.source.getFullPath() + " to " + this.dest.getFullPath();
        }
    }
}

