/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.concept.operations.internal;

import com.ur.polyscope.concept.operations.UserInputResource;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ConfirmationMessageProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import java.util.concurrent.CountDownLatch;

public class UserInputResourceImpl
implements UserInputResource {
    protected final FileManagerTextResource textResource;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final ConfirmationMessageProvider confirmationMessageProvider;

    public UserInputResourceImpl(ViewContext viewContext) {
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.confirmationMessageProvider = new ConfirmationMessageProvider(this.textResource);
    }

    public boolean canOverwriteFileName(ConceptLocation destination) {
        final boolean[] overwrite = new boolean[]{true};
        final CountDownLatch latch = new CountDownLatch(1);
        this.confirmationDialogCreator.showConfirmationDialog(this.confirmationMessageProvider.confirmOverwriteFile(destination.getName()), new ConfirmationDialogListener(){

            public void onOkClicked() {
                overwrite[0] = true;
                latch.countDown();
            }

            public void onCancelClicked() {
                overwrite[0] = false;
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {}
        return overwrite[0];
    }
}

