/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.CardPanel;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import javax.swing.JComponent;

abstract class AbstractFileChooserCardPanel
extends CardPanel {
    protected IFileChooser fileChooser;
    protected FileContainer fileContainer;

    public AbstractFileChooserCardPanel(@Source(value=USBState.class) Recipe<USBState> usbStateRecipe) {
        usbStateRecipe.distinctUntilChanged().executeOnUIThread().subscribe(usbState -> {
            if (this.fileChooser != null) {
                this.fileChooser.rescan();
            }
        });
    }

    protected final void setFileChooser(IFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.setLayout(new BorderLayout());
        this.add((JComponent)((Object)fileChooser), "Center");
    }

    public void enter(Object o) {
        super.enter(o);
        if (o instanceof FileContainer) {
            this.fileChooser.rescan();
            this.fileContainer = (FileContainer)o;
            this.fileChooser.setFileContainer(this.fileContainer);
        } else if (this.fileContainer == null) {
            this.fileChooser.rescan();
            Log.error((String)("enter(Object o) called without a FileContainer, parameter o was: " + (o == null ? null : o.getClass().getName())), (Throwable)new Exception());
        } else {
            this.fileChooser.rescan();
        }
    }

    public Object exit() {
        this.fileChooser.getClipboardOperation().removeClipboardFileHolder();
        return super.exit();
    }

    public void navigateBack() {
        super.navigateBack();
        if (this.fileContainer instanceof PerformingFileContainer) {
            ((PerformingFileContainer)this.fileContainer).perform();
        }
    }
}

