/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.impl.CurrentFileName;
import com.ur.polyscope.filemanager.impl.FilePathUtils;
import com.ur.swing.DimensionUtils;
import java.awt.Font;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CurrentFileNameLoad
extends JLabel
implements CurrentFileName {
    private static final String FILE_NAME_INPUT_FIELD = "FileNameLabel.URFileChooser";
    private File file;
    private File topDirectory;

    public CurrentFileNameLoad() {
        this.initComponents();
    }

    private void initComponents() {
        this.setName(FILE_NAME_INPUT_FIELD);
    }

    @Override
    public void setTopDirectory(File topDirectory) {
        this.topDirectory = topDirectory == null ? new File("/") : topDirectory;
    }

    @Override
    public String getCurrentFileName() {
        return this.file == null ? "" : this.file.getName();
    }

    @Override
    public JComponent getCurrentFileComponent() {
        return this;
    }

    @Override
    public void setCurrentFile(File file) {
        if (file == null || file.isDirectory()) {
            this.clear();
            return;
        }
        String pathWithoutTop = FilePathUtils.removeTopDirFromPath(this.topDirectory.getPath(), file.getPath());
        String resolvedRelativeParents = FilePathUtils.resolveRelativeParents(pathWithoutTop);
        String absoluteAfterTopPath = FilePathUtils.removeLeadingSlashIfNoParent(resolvedRelativeParents);
        this.file = new File(absoluteAfterTopPath);
        String shortenedPath = this.getShortenedFilePath();
        this.setText(shortenedPath);
    }

    @Override
    public void clear() {
        this.file = null;
        this.setText("");
    }

    private String getShortenedFilePath() {
        String name = this.file.getName();
        String path = this.file.getPath().substring(0, this.file.getPath().lastIndexOf(name));
        if (this.doesPathFitInLabel(this.file.getPath())) {
            return this.file.getPath();
        }
        if (path.startsWith(File.separator)) {
            path = path.replaceFirst(File.separator, "");
        }
        String[] pathParts = path.split(File.separator);
        int i = 0;
        while (i < pathParts.length) {
            pathParts[i] = "...";
            String shortenedPath = new File(CurrentFileNameLoad.buildPathFromParts(pathParts), name).getPath();
            if (this.doesPathFitInLabel(shortenedPath)) {
                return shortenedPath;
            }
            ++i;
        }
        return name;
    }

    private static String buildPathFromParts(String[] parts) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result.append(String.valueOf(File.separator) + part);
            ++n2;
        }
        return result.toString();
    }

    private boolean doesPathFitInLabel(String path) {
        int labelWidth;
        int stringWidth = DimensionUtils.getLabelTextWidth((Font)this.getFont(), (String)path);
        return stringWidth < (labelWidth = this.getActualOrConfiguredWidth());
    }

    private int getActualOrConfiguredWidth() {
        int actualWidth = this.getWidth();
        return actualWidth > 0 ? actualWidth : this.getMinimumSize().width;
    }
}

