/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.impl.CurrentFileName;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.operations.FinalOperation;
import com.ur.swing.CompletedListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.persist.FileUtils;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class CurrentFileNameSave
extends JTextField
implements CurrentFileName {
    private static final String FILE_NAME_INPUT_FIELD = "FileNameField.URFileChooser";
    private final FileSystemModel fileSystemModel;
    private final FinalOperation finalOperation;
    private String finalExtension = "";

    public CurrentFileNameSave(FileSystemModel fileSystemModel, FinalOperation finalOperation) {
        this.fileSystemModel = fileSystemModel;
        this.finalOperation = finalOperation;
        this.initComponents();
    }

    @Override
    public void setTopDirectory(File file) {
    }

    private void initComponents() {
        this.setName(FILE_NAME_INPUT_FIELD);
        this.setEditable(false);
        ValidationStrategy fileNameValidator = ValidationFactory.getFileSystemNameValidator();
        TextFieldUtils.bindTextPicker((JComponent)this, (TextHolder)new TextHolder(){

            public String getText() {
                return CurrentFileNameSave.this.removeSupportedExtension(CurrentFileNameSave.this.getCurrentFileName());
            }

            public void setText(String text) {
                CurrentFileNameSave.this.setText(text);
            }
        }, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                CurrentFileNameSave.this.finalOperation.execute(CurrentFileNameSave.this.getFileFieldFile());
            }

            public void requestCancel() {
            }
        }, (ValidationStrategy)fileNameValidator);
    }

    @Override
    public String getCurrentFileName() {
        return this.getText();
    }

    @Override
    public JComponent getCurrentFileComponent() {
        return this;
    }

    @Override
    public void setCurrentFile(File file) {
        if (file != null && !file.isDirectory()) {
            this.setText(file.getName());
        }
    }

    @Override
    public void clear() {
        this.setText("");
    }

    public String removeSupportedExtension(String text) {
        if (this.finalOperation.isFileTypeSpecified() && this.finalOperation.canExecute(new File(text))) {
            String name = FileUtils.removeExtension((String)text);
            this.finalExtension = StringUtils.difference((String)name, (String)text);
            return name;
        }
        return text;
    }

    private File getFileFieldFile() {
        return this.fileSystemModel.createFile(String.valueOf(this.removeSupportedExtension(this.getText())) + this.finalExtension);
    }
}

