/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.swing.dialog.ErrorMessage;
import javax.inject.Inject;

public class ErrorMessageProvider {
    private static final int MAX_FILE_NAME_LENGTH = 70;
    private static final int MAX_EXTENSION_LENGTH = 20;
    private final FileManagerTextResource textBundle;

    @Inject
    public ErrorMessageProvider(FileManagerTextResource textBundle) {
        this.textBundle = textBundle;
    }

    public ErrorMessage unableToSaveProgram(String path) {
        return new ErrorMessage(this.textBundle.unableToSaveProgram(), this.textBundle.couldNotSaveProgramFileExplanation(path), this.textBundle.ensureSelectedSaveDirectoryExists());
    }

    public ErrorMessage unableToSaveScriptFile(String fileName) {
        return new ErrorMessage(this.textBundle.unableToSaveScriptFile(), this.textBundle.couldNotSaveFile(ErrorMessageProvider.truncateFileNameIfNecessary(fileName)), this.textBundle.ensureSelectedSaveDirectoryExists());
    }

    public ErrorMessage fatalUnknownException(String title) {
        return new ErrorMessage(title, this.textBundle.anUnexpectedErrorOccurredExplanation(), this.textBundle.anUnexpectedErrorOccurredSuggestion());
    }

    public ErrorMessage failuretoBackupToUsb(String message) {
        return new ErrorMessage(this.textBundle.backupToUsbErrorTitle(), message);
    }

    public ErrorMessage usbDriveNotFound() {
        return new ErrorMessage(this.textBundle.backupToUsbErrorTitle(), this.textBundle.usbDriveNotFound(), this.textBundle.usbDriveNotFoundSuggestion());
    }

    public ErrorMessage failedToFormatUsb() {
        return new ErrorMessage(this.textBundle.formatUsbTitle(), this.textBundle.formatUsbProblem());
    }

    public ErrorMessage errorInFileRename() {
        return new ErrorMessage(this.textBundle.errorInRenameFileName(), this.textBundle.errorInRenameFileNameExplanation());
    }

    public ErrorMessage errorInDirectoryRename() {
        return new ErrorMessage(this.textBundle.errorInRenameDirectoryName(), this.textBundle.errorInRenameDirectoryNameExplanation());
    }

    public static String truncateFileNameIfNecessary(String fileName) {
        if (fileName.length() > 70) {
            String truncatedName = String.valueOf(fileName.substring(0, 70)) + "...";
            if (fileName.contains(".")) {
                String extension = fileName.substring(fileName.lastIndexOf("."));
                if (extension.length() > 20) {
                    return String.valueOf(truncatedName) + extension.substring(0, 20) + "...";
                }
                return String.valueOf(truncatedName) + extension;
            }
            return truncatedName;
        }
        return fileName;
    }
}

