/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.lang.StringUtils;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.CurrentFileName;
import com.ur.polyscope.filemanager.impl.CurrentFileNameNull;
import com.ur.polyscope.filemanager.impl.FileElementRenderer;
import com.ur.polyscope.filemanager.impl.FileFilterView;
import com.ur.polyscope.filemanager.impl.FileSelectionListener;
import com.ur.polyscope.filemanager.impl.FileSystemContext;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.SelectFile;
import com.ur.polyscope.filemanager.impl.SwingBreadcrumbResourceCreator;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.actions.FileSystemActionFactory;
import com.ur.polyscope.filemanager.impl.breadcrumb.Breadcrumb;
import com.ur.polyscope.filemanager.impl.operations.ClipboardOperation;
import com.ur.polyscope.filemanager.impl.operations.FileOperations;
import com.ur.polyscope.filemanager.impl.operations.FinalOperation;
import com.ur.polyscope.filemanager.impl.operations.NullFinalOperation;
import com.ur.polyscope.filemanager.impl.operations.OperationRestriction;
import com.ur.polyscope.filemanager.impl.operations.RenameOperation;
import com.ur.polyscope.filemanager.impl.usb.USBBackupIndicator;
import com.ur.polyscope.filemanager.impl.usb.USBBackupIndicatorFactory;
import com.ur.polyscope.filemanager.resources.ImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.DialogBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.persist.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.metal.MetalButtonUI;
import org.jdesktop.swingx.VerticalLayout;

public class FileChooser
extends JPanel
implements IFileChooser,
SelectFile {
    protected static final String HOME_DIRECTORY = "homeDirectory.URFileChooser";
    private static final String FILE_LIST = "fileList.URFileChooser";
    private final FileManagerTextResource textResource;
    private final WidgetFactory widgetFactory;
    private final RenameOperation renameOperation;
    private final URFontFactory fontFactory;
    private FileManagerConfiguration configuration;
    private FileContainer finallySelectedFile;
    private JList currentDirectoryList;
    private JButton newDirectory;
    private JButton cutFile;
    private JButton copyFile;
    private JButton deleteFile;
    private JButton renameFile;
    private JButton cancel;
    private JButton openOrSave;
    private FileFilterView fileFilters;
    private Breadcrumb breadcrumb;
    private CurrentFileName currentFileName;
    private JComponent currentFileComponent;
    private final CardPanel parentPanel;
    private final FileSystemActionFactory fileSystemActionFactory;
    private final FileSystemModel fileSystemModel;
    private final FileElementRenderer fileElementRenderer;
    private FinalOperation finalOperation;
    private final ClipboardOperation clipboardOperation;
    private final USBBackupIndicatorFactory usbBackupIndicatorFactory;
    private final OperationRestriction operationRestriction;

    public FileChooser(CardPanel parent, ViewContext viewContext, FileSystemModel fileSystemModel, FileElementRenderer fileElementRenderer, FileSystemContext fileSystemContext) {
        this.parentPanel = parent;
        this.fontFactory = viewContext.getFontFactory();
        this.widgetFactory = viewContext.createWidgetFactory();
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.fileSystemModel = fileSystemModel;
        this.fileElementRenderer = fileElementRenderer;
        this.fileSystemActionFactory = fileSystemContext.getFileSystemActionFactory();
        FileOperations fileOperations = fileSystemContext.getFileOperations();
        this.clipboardOperation = fileOperations.getClipboardOperationFactory().get(this, viewContext);
        this.renameOperation = fileOperations.getRenameOperationFactory().get(this);
        this.usbBackupIndicatorFactory = fileSystemContext.getUSBBackupIndicatorFactory();
        this.operationRestriction = fileSystemContext.getOperationRestriction();
        this.finalOperation = new NullFinalOperation();
        this.currentFileName = new CurrentFileNameNull();
        this.finallySelectedFile = new FileContainer();
        this.initComponents();
        this.initHelpIds((HelpIdAssigner)viewContext.getHelpIdAssigner());
    }

    @Override
    public JList getCurrentDirectoryList() {
        return this.currentDirectoryList;
    }

    @Override
    public void updateUIFields() {
        this.rescan();
        this.unMarkElements();
        this.currentFileName.clear();
    }

    @Override
    public void setConfiguration(FileManagerConfiguration configuration, FinalOperation finalOperation, CurrentFileName currentFileName) {
        this.finalOperation = finalOperation;
        this.currentFileName = currentFileName;
        this.configuration = configuration;
        this.initComponents();
        this.unMarkElements();
        this.currentFileName.setTopDirectory(this.configuration.directory());
        this.setTitle(this.configuration.getTitle());
        this.fileSystemModel.setTopDirectory(this.configuration.directory());
        this.fileSystemModel.setCurrentDirectory(this.configuration.directory());
        this.fileFilters.setFilters(configuration.fileFilters());
    }

    @Override
    public boolean isRestrictedAccess() {
        if (this.configuration != null) {
            return this.configuration.isRestrictedAccess();
        }
        return true;
    }

    private void initHelpIds(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId(this.currentFileComponent, "gui:loadscreen_file_field");
        helpIdAssigner.assignHelpId((JComponent)this.openOrSave, "gui:loadscreen_open_button");
        helpIdAssigner.assignHelpId((JComponent)this.cancel, "gui:loadscreen_cancel_button");
        helpIdAssigner.assignHelpId((JComponent)this.fileFilters, "gui:loadscreen_file_filter");
        helpIdAssigner.assignHelpId((JComponent)this.currentDirectoryList, "gui:loadscreen_selection_area");
    }

    private JPanel createBreadCrumbPanel() {
        this.breadcrumb = new Breadcrumb(new SwingBreadcrumbResourceCreator());
        this.breadcrumb.addActionListener(e -> {
            Breadcrumb cmb = (Breadcrumb)e.getSource();
            File dir = cmb.getCurrentDirectory();
            if (dir != null) {
                this.setCurrentDirectory(dir);
                this.rescanCurrentDirectory();
            }
        });
        Dimension dimension = new Dimension(1150, 40);
        this.breadcrumb.setPreferredSize(dimension);
        this.breadcrumb.setMinimumSize(dimension);
        this.breadcrumb.setMaximumSize(dimension);
        this.breadcrumb.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.breadcrumb.setLayout(new BoxLayout(this.breadcrumb, 2));
        this.breadcrumb.setBorder(new CompoundBorder(new MatteBorder(0, 0, 5, 0, G5LookAndFeel.BETWEEN_CARD_COLOR), new MatteBorder(5, 5, 5, 5, Color.WHITE)));
        return this.breadcrumb;
    }

    private void setCurrentlySelectedFileAndDirectory(File file) {
        if (file == null) {
            this.setCurrentDirectory(this.fileSystemModel.getTopDirectory());
            this.currentFileName.clear();
        } else {
            File directory = file.getParentFile();
            this.setCurrentDirectory(directory == null ? this.fileSystemModel.getTopDirectory() : directory);
            this.currentFileName.setCurrentFile(file);
        }
        this.rescan();
    }

    @Override
    public void setCurrentDirectory(File directory) {
        this.fileSystemModel.setCurrentDirectory(directory);
        this.currentFileName.setCurrentFile(directory);
        SwingUtilities.invokeLater(() -> {
            this.breadcrumb.setPath(this.fileSystemModel.getCurrentDirectory(), this.fileSystemModel.getTopDirectory());
            this.unMarkElements();
        });
    }

    @Override
    public void openDirectory(File theFile) {
        this.setCurrentDirectory(theFile);
        this.rescan();
    }

    @Override
    public void markFile(File theFile) {
        this.currentFileName.setCurrentFile(theFile);
        this.rescanRestrictedAccess();
        this.deleteFile.setEnabled(!this.operationRestriction.isDeleteRestricted(theFile, this.isRestrictedAccess()));
        this.renameFile.setEnabled(!this.operationRestriction.isRenameRestricted(theFile, this.isRestrictedAccess()));
        this.cutFile.setEnabled(!this.operationRestriction.isCutRestricted(theFile, this.isRestrictedAccess()));
        this.copyFile.setEnabled(!this.operationRestriction.isCopyRestricted(theFile, this.isRestrictedAccess()));
    }

    @Override
    public File getSelectedFile() {
        File currentlySelectedFile;
        Object tmp = this.currentDirectoryList.getSelectedValue();
        File result = tmp instanceof File ? ((currentlySelectedFile = (File)tmp).isDirectory() || currentlySelectedFile.getName().equals(this.getFileFieldText()) ? currentlySelectedFile : this.fileSystemModel.createFile(this.getFileFieldText())) : this.fileSystemModel.createFile(this.getFileFieldText());
        return result;
    }

    @Override
    public File getCurrentDirectory() {
        return this.fileSystemModel.getCurrentDirectory();
    }

    @Override
    public File getTopDirectory() {
        return this.fileSystemModel.getTopDirectory();
    }

    @Override
    public FileContainer getFinallySelectedFile() {
        return this.finallySelectedFile;
    }

    @Override
    public CardPanel getParentPanel() {
        return this.parentPanel;
    }

    @Override
    public boolean isFileSelected() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return false;
        }
        return selectedFile.isFile();
    }

    @Override
    public boolean isDirectoryEndpoint() {
        if (this.configuration != null) {
            return this.configuration.isDirectoryEndpoint();
        }
        return false;
    }

    @Override
    public ClipboardOperation getClipboardOperation() {
        return this.clipboardOperation;
    }

    private String getFileFieldText() {
        String fileName = this.currentFileName.getCurrentFileName();
        if (StringUtils.isNullOrOnlyWhitespace((String)fileName)) {
            fileName = "";
        } else if (FileUtils.getExtension((String)fileName) == null && !this.fileSystemModel.getCurrentFileFilter().getFileExtension().isEmpty()) {
            fileName = String.valueOf(fileName) + "." + this.fileSystemModel.getCurrentFileFilter().getFileExtension();
        }
        return fileName;
    }

    @Override
    public void rescanCurrentDirectory() {
        this.fileSystemModel.rescanCurrentDirectory();
    }

    private void rescanPathList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooser.this.breadcrumb.setPath(FileChooser.this.fileSystemModel.getCurrentDirectory(), FileChooser.this.fileSystemModel.getTopDirectory());
            }
        });
    }

    public void rescanRestrictedAccess() {
        this.newDirectory.setEnabled(!this.operationRestriction.isNewDirectoryRestricted(this.isRestrictedAccess()));
    }

    @Override
    public void rescan() {
        this.rescanPathList();
        this.rescanCurrentDirectory();
        this.rescanRestrictedAccess();
        this.clipboardOperation.rescanClipboardFileHolder();
    }

    @Override
    public final void addFileFilter(URFileFilter extraFilter) {
        this.fileFilters.addFileFilter(extraFilter);
    }

    private void unMarkElements() {
        int[] ids = new int[]{};
        this.currentDirectoryList.setSelectedIndices(ids);
        this.deleteFile.setEnabled(false);
        this.renameFile.setEnabled(false);
        this.cutFile.setEnabled(false);
        this.copyFile.setEnabled(false);
    }

    @Override
    public void setFileContainer(FileContainer fc) {
        this.finallySelectedFile = fc;
        if (fc == null) {
            this.currentFileName.clear();
        } else {
            String fileName = FileUtils.removeExtension((String)fc.getName());
            if (this.textResource.placeholderUnnamed().contains(fileName)) {
                this.finallySelectedFile.setFile(null);
                this.currentFileName.clear();
            } else {
                this.setCurrentlySelectedFileAndDirectory(fc.getFile());
            }
        }
    }

    private void initComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.currentDirectoryList = new JList();
        this.currentDirectoryList.setBackground(Color.white);
        this.currentDirectoryList.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.currentDirectoryList.setCellRenderer(this.fileElementRenderer);
        this.currentDirectoryList.setLayoutOrientation(1);
        this.currentDirectoryList.setSelectionMode(0);
        this.currentDirectoryList.setVisibleRowCount(-1);
        this.currentDirectoryList.setName(FILE_LIST);
        this.currentDirectoryList.setModel(this.fileSystemModel);
        JScrollPane jScrollPane = new JScrollPane(this.currentDirectoryList);
        new URFingerDragScrollMouseListener((Component)this.currentDirectoryList);
        this.currentDirectoryList.addMouseListener(new FileSelectionListener(this, this.currentDirectoryList));
        JPanel directoryView = new JPanel();
        directoryView.setLayout(new BorderLayout());
        directoryView.setBorder(new MatteBorder(5, 0, 0, 0, G5LookAndFeel.BETWEEN_CARD_COLOR));
        directoryView.add((Component)this.createBreadCrumbPanel(), "North");
        jScrollPane.setBorder(new MatteBorder(0, 5, 5, 5, Color.WHITE));
        directoryView.add((Component)jScrollPane, "Center");
        directoryView.add((Component)this.createFileAndFilter(), "South");
        this.add((Component)this.createActionButtons(), "North");
        this.add((Component)directoryView, "Center");
        this.add((Component)this.createOpenSaveAndClose(), "South");
    }

    private void setTitle(String title) {
        this.setBorder(new CompoundBorder((Border)new DialogBorder(title, G5LookAndFeel.SELECTED_HEADER_BACKGROUND), new MatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR)));
    }

    private JPanel createOpenSaveAndClose() {
        JPanel butBox = new JPanel();
        butBox.setLayout(new BoxLayout(butBox, 2));
        butBox.add(Box.createHorizontalGlue());
        this.openOrSave = this.widgetFactory.createButton((Action)((Object)this.finalOperation.getFileAction()));
        this.cancel = this.widgetFactory.createButton((Action)((Object)this.fileSystemActionFactory.getCancelAction(this)));
        butBox.add(this.openOrSave);
        butBox.add(Box.createHorizontalStrut(10));
        butBox.add(this.cancel);
        butBox.setBorder(new MatteBorder(5, 5, 5, 5, Color.WHITE));
        return butBox;
    }

    private JPanel createFileAndFilter() {
        JPanel fileAndFilter = new JPanel();
        fileAndFilter.setLayout(new BoxLayout(fileAndFilter, 2));
        fileAndFilter.setBorder(new MatteBorder(5, 0, 5, 0, G5LookAndFeel.BETWEEN_CARD_COLOR));
        fileAndFilter.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        fileAndFilter.add(this.createFileField());
        fileAndFilter.add(Box.createHorizontalStrut(5));
        fileAndFilter.add(this.createFilterBox());
        return fileAndFilter;
    }

    private JPanel createActionButtons() {
        JPanel result = new JPanel();
        this.newDirectory = this.createButton(this.fileSystemActionFactory.getCreateDirectoryAction(this, this.fileSystemModel), "new.directory.URFileChooser");
        this.cutFile = this.createButton(this.fileSystemActionFactory.getCutAction(this, this.clipboardOperation), "cut.URFileChooser");
        this.cutFile.setEnabled(false);
        this.copyFile = this.createButton(this.fileSystemActionFactory.getCopyAction(this, this.clipboardOperation), "copy.URFileChooser");
        this.copyFile.setEnabled(false);
        JButton pasteFile = this.createButton(this.fileSystemActionFactory.getPasteAction(this, this.clipboardOperation), "paste.URFileChooser");
        this.deleteFile = this.createButton(this.fileSystemActionFactory.getDeleteAction(this), "delete.URFileChooser");
        this.deleteFile.setEnabled(false);
        this.renameFile = this.createButton(this.textResource.RENAME(), ImageResource.rename(), "rename.URFileChooser");
        this.renameOperation.bindTextPicker(this.renameFile);
        this.renameFile.setEnabled(false);
        result.add(this.newDirectory);
        result.add(Box.createHorizontalStrut(30));
        result.add(this.cutFile);
        result.add(this.copyFile);
        result.add(pasteFile);
        result.add(this.deleteFile);
        result.add(Box.createHorizontalStrut(30));
        result.add(this.renameFile);
        result.add(Box.createHorizontalStrut(30));
        USBBackupIndicator usbBackupIndicator = this.usbBackupIndicatorFactory.get(this);
        result.add(Box.createHorizontalGlue());
        result.add(usbBackupIndicator);
        result.setLayout(new BoxLayout(result, 2));
        result.setMaximumSize(new Dimension(Integer.MAX_VALUE, 48));
        result.setBorder(new MatteBorder(5, 5, 5, 5, Color.WHITE));
        return result;
    }

    private JButton createButton(String name, Icon icn, String buttonName) {
        AbstractFileSystemAction placeholderAction = new AbstractFileSystemAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        placeholderAction.putValue("SmallIcon", icn);
        placeholderAction.putValue("Name", name);
        return this.createButton(placeholderAction, buttonName);
    }

    private JButton createButton(AbstractFileSystemAction actionBtn, String buttonName) {
        actionBtn.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        JButton btn = this.widgetFactory.createButton((Action)((Object)actionBtn));
        btn.setForeground(Color.black);
        btn.setBackground(Color.WHITE);
        Dimension dimBtn = actionBtn.getRecommendedDimension(btn.getFont());
        btn.setMaximumSize(dimBtn);
        btn.setMinimumSize(dimBtn);
        btn.setPreferredSize(dimBtn);
        btn.setName(buttonName);
        btn.setUI(new FileButtonLookAndFeel());
        return btn;
    }

    private JPanel createFileField() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new VerticalLayout(5));
        this.currentFileComponent = this.currentFileName.getCurrentFileComponent();
        if (this.isDirectoryEndpoint()) {
            this.currentFileComponent.setEnabled(false);
        }
        JLabel lblFilename = new JLabel(this.textResource.filename());
        lblFilename.setMaximumSize(new Dimension(550, 25));
        lblFilename.setHorizontalTextPosition(2);
        if (this.currentFileComponent != null) {
            this.currentFileComponent.setMaximumSize(new Dimension(550, 32));
            this.currentFileComponent.setMinimumSize(new Dimension(550, 32));
            this.currentFileComponent.setPreferredSize(new Dimension(550, 32));
            this.currentFileComponent.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        }
        result.add(lblFilename);
        result.add(this.currentFileComponent);
        result.setBorder(new MatteBorder(5, 5, 0, 5, Color.WHITE));
        return result;
    }

    private JPanel createFilterBox() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new VerticalLayout(5));
        JLabel lblFilter = new JLabel(this.textResource.filter());
        lblFilter.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        lblFilter.setHorizontalTextPosition(2);
        result.add(lblFilter);
        this.fileFilters = new FileFilterView(this.fileSystemModel, this, this.textResource);
        this.fileFilters.initializeFilters();
        this.fileFilters.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        lblFilter.setMaximumSize(new Dimension(550, 25));
        lblFilter.setHorizontalTextPosition(2);
        this.fileFilters.setMaximumSize(new Dimension(550, 32));
        this.fileFilters.setMinimumSize(new Dimension(550, 32));
        this.fileFilters.setPreferredSize(new Dimension(550, 32));
        result.add(this.fileFilters);
        result.setBorder(new MatteBorder(5, 5, 0, 5, Color.WHITE));
        return result;
    }

    private static final class FileButtonLookAndFeel
    extends MetalButtonUI {
        private FileButtonLookAndFeel() {
        }

        @Override
        protected Color getSelectColor() {
            return G5LookAndFeel.DISABLED_BACKGROUND;
        }
    }
}

