/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.SwingFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.DefaultFileRenderer;
import com.ur.util.persist.FileUtils;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class FileElementRenderer
implements ListCellRenderer {
    private Map<String, SwingFileRenderer> fileRenderers;
    private DefaultFileRenderer defaultFileRenderer;

    @Inject
    public FileElementRenderer(Map<String, SwingFileRenderer> fileRenderers, DefaultFileRenderer defaultFileRenderer) {
        this.fileRenderers = fileRenderers;
        this.defaultFileRenderer = defaultFileRenderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        File theFile = (File)value;
        String ext = FileUtils.getExtension((File)theFile);
        DefaultFileRenderer renderer = this.fileRenderers.containsKey(ext) ? this.fileRenderers.get(ext) : this.defaultFileRenderer;
        return renderer.render(theFile, isSelected, cellHasFocus);
    }
}

