/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.lang.EqualsUtil;
import com.ur.util.persist.FileUtils;
import java.io.File;

public final class FileExtensions {
    public static final String BACKUP = "old";
    public static final String INSTALLATION = "installation";
    public static final String PROGRAM = "urp";
    public static final String SCRIPT = "script";
    public static final String URCAP = "urcap";
    public static final String URCAPX = "urcapx";
    public static final String VARIABLES = "variables";

    private FileExtensions() {
    }

    public static boolean isBackup(String fileName) {
        return fileName.toLowerCase().matches(".*?.old[0-9]$");
    }

    public static boolean isBackup(File file) {
        return FileExtensions.isBackup(file.getAbsolutePath());
    }

    public static boolean isInstallation(String fileName) {
        return FileExtensions.hasExtension(fileName, INSTALLATION);
    }

    public static boolean isInstallation(File file) {
        return FileExtensions.isInstallation(file.getAbsolutePath());
    }

    public static boolean isProgram(String fileName) {
        return FileExtensions.hasExtension(fileName, PROGRAM);
    }

    public static boolean isProgram(File file) {
        return FileExtensions.isProgram(file.getAbsolutePath());
    }

    public static boolean isVariables(String fileName) {
        return FileExtensions.hasExtension(fileName, VARIABLES);
    }

    public static boolean isVariables(File file) {
        return FileExtensions.isVariables(file.getAbsolutePath());
    }

    private static boolean hasExtension(String fileName, String desiredExtension) {
        String parsedExtension = FileUtils.getExtension((String)fileName);
        return EqualsUtil.equals((Object)desiredExtension, (Object)parsedExtension);
    }
}

