/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.AllFilesFilter;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.SelectFile;
import javax.swing.JComboBox;

class FileFilterView
extends JComboBox<URFileFilter> {
    private final AllFilesFilter allFilesFilter;
    private final FileSystemModel fileSystemModel;
    private final SelectFile urFileChooser;

    public FileFilterView(FileSystemModel fileSystemModel, SelectFile urFileChooser, FileManagerTextResource textResource) {
        this.fileSystemModel = fileSystemModel;
        this.urFileChooser = urFileChooser;
        this.allFilesFilter = new AllFilesFilter(textResource);
    }

    public void initializeFilters() {
        this.setFilters(new URFileFilter[0]);
        this.addActionListener(e -> {
            if (this.hasFocus()) {
                this.fileSystemModel.setCurrentFileFilter((URFileFilter)this.getSelectedItem());
                this.urFileChooser.rescanCurrentDirectory();
            }
        });
    }

    public void addFileFilter(URFileFilter extraFilter) {
        boolean allreadyThere = false;
        if (extraFilter == null) {
            this.setSelectedIndex(0);
        } else {
            int i = 0;
            while (i < this.getItemCount()) {
                if (((URFileFilter)this.getItemAt(i)).getClass() == extraFilter.getClass()) {
                    allreadyThere = true;
                    this.setSelectedIndex(i);
                }
                ++i;
            }
            if (!allreadyThere) {
                this.addItem(extraFilter);
                this.setSelectedIndex(this.getItemCount() - 1);
            }
        }
        this.updateUI();
    }

    public void setFilters(URFileFilter[] fileFilters) {
        this.removeAll();
        if (!this.urFileChooser.isDirectoryEndpoint()) {
            this.addFileFilter(this.allFilesFilter);
        }
        URFileFilter[] uRFileFilterArray = fileFilters;
        int n = fileFilters.length;
        int n2 = 0;
        while (n2 < n) {
            URFileFilter each = uRFileFilterArray[n2];
            this.addFileFilter(each);
            ++n2;
        }
        this.fileSystemModel.setCurrentFileFilter((URFileFilter)this.getSelectedItem());
    }
}

