/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import java.io.File;

public final class FilePathUtils {
    private FilePathUtils() {
    }

    public static String resolveRelativeParents(String inputPath) {
        String relativeParent = String.valueOf(File.separator) + "..";
        int parentIndex = inputPath.indexOf(relativeParent);
        if (parentIndex == -1) {
            return inputPath;
        }
        String parentPath = inputPath.substring(0, parentIndex);
        String resolvedParentPath = new File(parentPath).getParent();
        String inputRemainder = inputPath.substring(parentIndex + relativeParent.length());
        return FilePathUtils.resolveRelativeParents(String.valueOf(resolvedParentPath) + inputRemainder);
    }

    public static String removeLeadingSlashIfNoParent(String filePath) {
        File pathAsFile = new File(filePath);
        if (pathAsFile.getParent() == null || pathAsFile.getParent().equals(File.separator)) {
            return pathAsFile.getName();
        }
        return pathAsFile.getPath();
    }

    public static String removeTopDirFromPath(String topDir, String path) {
        if (topDir.equals(File.separator)) {
            return path;
        }
        int topStartIndex = path.indexOf(topDir);
        if (topStartIndex > -1) {
            int cutAfterTop = topStartIndex + topDir.length();
            return path.substring(cutAfterTop);
        }
        return path;
    }
}

