/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.filemanager.OpenFileConfiguration;
import com.ur.polyscope.filemanager.SaveFileConfiguration;
import com.ur.polyscope.filemanager.impl.OpenFileCardPanel;
import com.ur.polyscope.filemanager.impl.OpenSettingsFileCardPanel;
import com.ur.polyscope.filemanager.impl.SaveFileCardPanel;
import javax.inject.Inject;

public class FilePersistenceImpl
implements FileTypePersistence {
    private final OpenSettingsFileCardPanel openSettingsFileContainer;
    private final OpenFileCardPanel openFile;
    private final SaveFileCardPanel saveFileCardPanel;

    @Inject
    public FilePersistenceImpl(OpenSettingsFileCardPanel openSettingsFileContainer, OpenFileCardPanel openFile, SaveFileCardPanel saveFileCardPanel) {
        this.openSettingsFileContainer = openSettingsFileContainer;
        this.openFile = openFile;
        this.saveFileCardPanel = saveFileCardPanel;
    }

    public void openSettingsFile(FileContainer container, FileManagerConfiguration configuration) {
        this.openSettingsFileContainer.fileContainer = container;
        this.openSettingsFileContainer.getFlipManager().stackCurrentCardAndSwitchTo(OpenSettingsFileCardPanel.class, (Object)configuration);
    }

    public void openSettingsFile(FileContainer container, FileManagerConfiguration configuration, String[] extensions) {
        this.openSettingsFileContainer.fileContainer = container;
        this.openSettingsFileContainer.getFlipManager().stackCurrentCardAndSwitchTo(OpenSettingsFileCardPanel.class, (Object)new OpenFileConfiguration(configuration, extensions));
    }

    public void openFile(FileContainer container, FileManagerConfiguration configuration) {
        this.openFile.fileContainer = container;
        this.openFile.getFlipManager().stackCurrentCardAndSwitchTo(OpenFileCardPanel.class, (Object)configuration);
    }

    public void openFile(FileContainer container, FileManagerConfiguration configuration, String[] extensions) {
        this.openFile.fileContainer = container;
        this.openFile.getFlipManager().stackCurrentCardAndSwitchTo(OpenFileCardPanel.class, (Object)new OpenFileConfiguration(configuration, extensions));
    }

    public void saveFile(FileContainer container, FileManagerConfiguration configuration) {
        this.saveFileCardPanel.fileContainer = container;
        this.saveFileCardPanel.getFlipManager().stackCurrentCardAndSwitchTo(SaveFileCardPanel.class, (Object)configuration);
    }

    public void saveFile(FileContainer container, FileManagerConfiguration configuration, String extension) {
        this.saveFileCardPanel.fileContainer = container;
        this.saveFileCardPanel.getFlipManager().stackCurrentCardAndSwitchTo(SaveFileCardPanel.class, (Object)new SaveFileConfiguration(configuration, extension));
    }
}

