/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.impl.SelectFile;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JList;

class FileSelectionListener
extends MouseAdapter {
    private static final long LONG_PRESS_LIMIT = 500L;
    private Timer t;
    private boolean isLongPress;
    private SelectFile selectFile;
    private JList currentDirectoryList;

    public FileSelectionListener(SelectFile selectFile, JList currentDirectoryList) {
        this.selectFile = selectFile;
        this.currentDirectoryList = currentDirectoryList;
    }

    private void onShortPress() {
        File theFile = (File)this.currentDirectoryList.getSelectedValue();
        if (theFile == null) {
            return;
        }
        if (theFile.isDirectory()) {
            this.selectFile.openDirectory(theFile);
        } else {
            this.selectFile.markFile(theFile);
        }
    }

    private void onLongPress() {
        File theFile = (File)this.currentDirectoryList.getSelectedValue();
        if (theFile != null) {
            this.selectFile.markFile(theFile);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.t == null) {
            this.isLongPress = false;
            this.t = new Timer();
            this.t.schedule(new TimerTask(){

                @Override
                public void run() {
                    FileSelectionListener.this.isLongPress = true;
                }
            }, 500L);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.t != null) {
            this.mouseReleased(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.t != null) {
            this.t.cancel();
            this.t = null;
        }
        if (this.isLongPress) {
            this.onLongPress();
        } else {
            this.onShortPress();
        }
    }

    public boolean isLongPress() {
        return this.isLongPress;
    }
}

