/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.filemanager.impl.URFileList;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.NameFileComparator;

public class FileSystemModel
extends URFileList {
    private final FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private File topDir = new File("/");
    private File currentDir = new File("/");
    private URFileFilter currentFileFilter;

    public File getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(File directory) {
        this.currentDir = directory != null && directory.isDirectory() && this.dirIsDescendentOfTopLevel(directory) ? directory : this.topDir;
    }

    public File getTopDirectory() {
        return this.topDir;
    }

    public void setTopDirectory(File dir) {
        this.topDir = dir;
        if (this.currentDir == null) {
            this.currentDir = this.topDir;
        }
    }

    public final void rescanCurrentDirectory() {
        this.testForDirectoryExistence();
        this.discoverFilesAndDirectories();
    }

    public void setCurrentFileFilter(URFileFilter filter) {
        this.currentFileFilter = filter;
    }

    public URFileFilter getCurrentFileFilter() {
        return this.currentFileFilter;
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    private void discoverFilesAndDirectories() {
        if (this.currentDir.exists()) {
            ArrayList<? extends File> files = new ArrayList<File>(this.applyFilter(this.currentFileFilter, Arrays.asList(this.fileSystemView.getFiles(this.currentDir, true))));
            List directories = files.stream().filter(File::isDirectory).sorted((Comparator<File>)new NameFileComparator(IOCase.INSENSITIVE)).collect(Collectors.toList());
            files.removeAll(directories);
            files.sort((Comparator<? extends File>)new NameFileComparator(IOCase.INSENSITIVE));
            this.clear();
            this.addFiles((Collection)directories);
            this.addFiles(files);
        }
    }

    private Collection<? extends File> applyFilter(URFileFilter currentFileFilter, List<File> asList) {
        return CollectionUtils.filter(asList, (Predicate)new FilePredicateFilter(currentFileFilter));
    }

    private void testForDirectoryExistence() {
        if (!this.currentDir.exists()) {
            this.setCurrentDirectory(this.topDir);
        }
    }

    private boolean dirIsDescendentOfTopLevel(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return file.getAbsolutePath().startsWith(this.topDir.getAbsolutePath());
    }

    public File createFile(String fileFieldText) {
        try {
            return this.fileSystemView.createFileObject(this.getCurrentDirectory(), fileFieldText);
        }
        catch (Exception e) {
            Log.error((String)"Could not find file", (Throwable)e);
            return null;
        }
    }

    private static class FilePredicateFilter
    implements Predicate<File> {
        private final URFileFilter currentFileFilter;

        public FilePredicateFilter(URFileFilter currentFileFilter) {
            this.currentFileFilter = currentFileFilter;
        }

        public boolean test(File file) {
            return this.currentFileFilter == null || this.currentFileFilter.accept(file);
        }
    }
}

