/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.swing.ImageIconWrapper;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;

public final class ImageLoader {
    private static final HashMap<String, Icon> cachedIconResources = new HashMap();

    private ImageLoader() {
    }

    public static Icon getIconImage(String path, String resource) {
        if (!cachedIconResources.containsKey(resource)) {
            String resourcePath = String.valueOf(path) + resource;
            cachedIconResources.put(resource, (Icon)new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
        }
        return cachedIconResources.get(resource);
    }

    private static BufferedImage tryToLoadImage(String resource) {
        try {
            return ImageIO.read(ImageLoader.class.getResource(resource));
        }
        catch (Exception exception) {
            try {
                return ImageIO.read(new File(resource));
            }
            catch (Exception e) {
                Log.warning((String)("Failed to load image '" + resource + "'."), (Throwable)e);
                return null;
            }
        }
    }
}

