/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.core.api.annotation.NoControlButtonVisibilityChange;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.OpenFileConfiguration;
import com.ur.polyscope.filemanager.impl.AbstractFileChooserCardPanel;
import com.ur.polyscope.filemanager.impl.CurrentFileNameLoad;
import com.ur.polyscope.filemanager.impl.FileChooser;
import com.ur.polyscope.filemanager.impl.FileSystemContext;
import com.ur.polyscope.filemanager.impl.operations.OpenFinalOperation;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.ViewContext;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@NoControlButtonVisibilityChange
class OpenFileCardPanel
extends AbstractFileChooserCardPanel {
    private final ViewContext viewContext;

    @Inject
    public OpenFileCardPanel(@Source(value=USBState.class) Recipe<USBState> usbStateRecipe, FileSystemContext fileSystemContext) {
        super(usbStateRecipe);
        this.viewContext = fileSystemContext.getViewContext();
        this.fileChooser = new FileChooser(this, this.viewContext, fileSystemContext.getFileSystemModel(), fileSystemContext.getFileElementRenderer(), fileSystemContext);
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser.setName("file.loader");
        this.setFileChooser(this.fileChooser);
    }

    @Override
    public void enter(Object o) {
        if (o != null) {
            String[] extensions;
            FileManagerConfiguration configuration;
            if (o instanceof FileManagerConfiguration) {
                configuration = (FileManagerConfiguration)o;
                extensions = new String[]{""};
            } else {
                OpenFileConfiguration fileConfiguration = (OpenFileConfiguration)o;
                configuration = fileConfiguration.getFileManagerConfiguration();
                extensions = fileConfiguration.getReadableExtensions();
            }
            OpenFinalOperation finalOperation = new OpenFinalOperation(this.fileChooser, this.viewContext, extensions);
            this.fileChooser.setConfiguration(configuration, finalOperation, new CurrentFileNameLoad());
            super.enter(this.fileContainer);
        }
    }
}

