/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.core.api.annotation.NoControlButtonVisibilityChange;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.SaveFileConfiguration;
import com.ur.polyscope.filemanager.impl.AbstractFileChooserCardPanel;
import com.ur.polyscope.filemanager.impl.CurrentFileNameSave;
import com.ur.polyscope.filemanager.impl.FileChooser;
import com.ur.polyscope.filemanager.impl.FileSystemContext;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.operations.SaveFinalOperation;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.ViewContext;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@NoControlButtonVisibilityChange
class SaveFileCardPanel
extends AbstractFileChooserCardPanel {
    private final FileSystemModel fileSystemModel;
    private final SaveFinalOperation finalOperation;
    private final ViewContext viewContext;

    @Inject
    public SaveFileCardPanel(@Source(value=USBState.class) Recipe<USBState> usbStateRecipe, FileSystemContext fileSystemContext) {
        super(usbStateRecipe);
        this.viewContext = fileSystemContext.getViewContext();
        this.fileSystemModel = fileSystemContext.getFileSystemModel();
        this.fileChooser = new FileChooser(this, this.viewContext, this.fileSystemModel, fileSystemContext.getFileElementRenderer(), fileSystemContext);
        this.finalOperation = new SaveFinalOperation(this.fileChooser, this.viewContext);
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser.setName("saveLoader");
        this.setFileChooser(this.fileChooser);
    }

    @Override
    public void enter(Object o) {
        if (o != null) {
            String extension;
            FileManagerConfiguration configuration;
            if (o instanceof FileManagerConfiguration) {
                configuration = (FileManagerConfiguration)o;
                extension = "";
            } else {
                SaveFileConfiguration fileConfiguration = (SaveFileConfiguration)o;
                configuration = fileConfiguration.getFileManagerConfiguration();
                extension = fileConfiguration.getWritableExtension();
            }
            this.finalOperation.setExtension(extension);
            CurrentFileNameSave currentFileNameSave = new CurrentFileNameSave(this.fileSystemModel, this.finalOperation);
            this.fileChooser.setConfiguration(configuration, this.finalOperation, currentFileNameSave);
            super.enter(this.fileContainer);
        }
    }
}

