/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.google.inject.TypeLiteral;
import com.ur.dashboardserver.DashBoardAction;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.react.Recipe;
import com.ur.polyscope.concept.operations.ConceptOperationFactory;
import com.ur.polyscope.concept.operations.internal.ConceptLocationFactoryImpl;
import com.ur.polyscope.concept.operations.internal.ConceptOperationFactoryImpl;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.FileStrategy;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.filemanager.SwingFileRenderer;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.i18n.impl.FileManagerTextResourceImpl;
import com.ur.polyscope.filemanager.impl.FileElementRenderer;
import com.ur.polyscope.filemanager.impl.FileManagerContributions;
import com.ur.polyscope.filemanager.impl.FilePersistenceImpl;
import com.ur.polyscope.filemanager.impl.FileSystemContext;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.ImageResourceWrapper;
import com.ur.polyscope.filemanager.impl.Settings;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.SharedStyleResource;
import com.ur.polyscope.filemanager.impl.StyleResourceWrapper;
import com.ur.polyscope.filemanager.impl.actions.FileSystemActionFactory;
import com.ur.polyscope.filemanager.impl.actions.FileSystemActionFactoryImpl;
import com.ur.polyscope.filemanager.impl.operations.BackupFileStrategy;
import com.ur.polyscope.filemanager.impl.operations.ClipboardFileHolder;
import com.ur.polyscope.filemanager.impl.operations.ClipboardModelSource;
import com.ur.polyscope.filemanager.impl.operations.FileOperations;
import com.ur.polyscope.filemanager.impl.operations.InstallationFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.OperationRestriction;
import com.ur.polyscope.filemanager.impl.operations.OperationRestrictionImpl;
import com.ur.polyscope.filemanager.impl.operations.ProgramFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.ProgramFileStrategy;
import com.ur.polyscope.filemanager.impl.operations.ScriptFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.URCapFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.URCapxFileRenderer;
import com.ur.polyscope.filemanager.impl.operations.VariablesFileRenderer;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.polyscope.filemanager.impl.usb.PerformUSBActionModelSource;
import com.ur.polyscope.filemanager.impl.usb.SimulatedUSBDirectoryFilter;
import com.ur.polyscope.filemanager.impl.usb.USBActionListener;
import com.ur.polyscope.filemanager.impl.usb.USBActionModelSource;
import com.ur.polyscope.filemanager.impl.usb.USBBackupIndicatorFactory;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilterImpl;
import com.ur.polyscope.filemanager.impl.usb.USBFileOperationImpl;
import com.ur.polyscope.filemanager.impl.usb.USBState;
import com.ur.swing.CardPanelMappedContribution;
import com.ur.util.logging.Log;
import java.util.Locale;

public class ServiceBinderImpl
implements ServicesBinder {
    public void bind(Binder binder) {
        this.bindTextResource(binder);
        binder.bindClass(FilePersistence.class, FilePersistenceImpl.class);
        binder.bindClass(FileTypePersistence.class, FilePersistenceImpl.class);
        binder.bindClass(OperationRestriction.class, OperationRestrictionImpl.class);
        binder.bindToExtensionPoint(CardPanelMappedContribution.class, FileManagerContributions.class);
        binder.bindClass(FileSystemActionFactory.class, FileSystemActionFactoryImpl.class);
        binder.bindToExtensionPoint(FileStrategy.class, ProgramFileStrategy.class);
        binder.bindToExtensionPoint(FileStrategy.class, BackupFileStrategy.class);
        binder.bindKeyToExtensionPoint((Object)"installation", SwingFileRenderer.class, InstallationFileRenderer.class);
        binder.bindKeyToExtensionPoint((Object)"urp", SwingFileRenderer.class, ProgramFileRenderer.class);
        binder.bindKeyToExtensionPoint((Object)"script", SwingFileRenderer.class, ScriptFileRenderer.class);
        binder.bindKeyToExtensionPoint((Object)"urcap", SwingFileRenderer.class, URCapFileRenderer.class);
        binder.bindKeyToExtensionPoint((Object)"urcapx", SwingFileRenderer.class, URCapxFileRenderer.class);
        binder.bindKeyToExtensionPoint((Object)"variables", SwingFileRenderer.class, VariablesFileRenderer.class);
        binder.requestStaticBinding(FileOperations.class);
        binder.requestStaticBinding(FileSystemModel.class);
        binder.requestStaticBinding(FileElementRenderer.class);
        binder.bindClass(SharedImageResource.class, ImageResourceWrapper.class);
        binder.bindClass(SharedStyleResource.class, StyleResourceWrapper.class);
        binder.requestStaticBinding(FileSystemContext.class);
        binder.bindToExtensionPoint(DashBoardAction.class, PerformUSBActionModelSource.class);
        binder.bindClass(IUSBFileOperation.class, USBFileOperationImpl.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<USBState>>(){}, USBActionModelSource.class);
        binder.requestStaticBinding(USBState.class);
        binder.requestStaticBinding(USBActionListener.class);
        binder.requestStaticBinding(USBBackupIndicatorFactory.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<ClipboardFileHolder>>(){}, ClipboardModelSource.class);
        this.bindUSBFilter(binder);
        binder.bindClass(ConceptLocationFactory.class, ConceptLocationFactoryImpl.class);
        binder.bindClass(ConceptOperationFactory.class, ConceptOperationFactoryImpl.class);
    }

    public void load(Builder builder) {
        builder.get(USBActionListener.class);
    }

    private void bindTextResource(Binder binder) {
        if (Settings.useDummyLanguage()) {
            binder.bindInstance(FileManagerTextResource.class, (Object)new FileManagerTextResourceImpl(new Locale("dummy")));
        } else {
            binder.bindClass(FileManagerTextResource.class, FileManagerTextResourceImpl.class);
        }
    }

    private void bindUSBFilter(Binder binder) {
        if (Settings.useSimulatedUSB()) {
            Log.warning((String)"Any directory names containing 'USB' will be treated as external media");
            binder.bindClass(USBDirectoryFilter.class, SimulatedUSBDirectoryFilter.class);
        } else {
            binder.bindClass(USBDirectoryFilter.class, USBDirectoryFilterImpl.class);
        }
    }
}

