/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl;

import com.ur.polyscope.filemanager.impl.breadcrumb.BreadcrumbResourceCreator;
import com.ur.polyscope.filemanager.resources.ImageResource;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;

public class SwingBreadcrumbResourceCreator
implements BreadcrumbResourceCreator {
    @Override
    public JButton createFileButton(String text, String buttonName) {
        JButton button = new JButton();
        button.setForeground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        button.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(SwingBreadcrumbResourceCreator.getTextWidth(text, button), 40);
        SwingBreadcrumbResourceCreator.setDimension(button, dimension);
        button.setText(text);
        button.setFocusable(false);
        button.setName(buttonName);
        return button;
    }

    private static int getTextWidth(String text, JButton button) {
        int result = (int)button.getFontMetrics(button.getFont()).getStringBounds(text, button.getGraphics()).getWidth();
        return result > 180 ? 180 : result;
    }

    private static void setDimension(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
    }

    @Override
    public JLabel createSeparatorIcon() {
        JLabel label = new JLabel();
        label.setIcon(ImageResource.seperator());
        Dimension dimension = this.getSeparatorDimension();
        label.setHorizontalAlignment(0);
        SwingBreadcrumbResourceCreator.setDimension(label, dimension);
        return label;
    }

    private Dimension getSeparatorDimension() {
        return new Dimension(54, 40);
    }

    @Override
    public JButton createRightButton() {
        JButton button = new JButton();
        button.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(40, 40);
        SwingBreadcrumbResourceCreator.setDimension(button, dimension);
        button.setIcon(ImageResource.arrowRight());
        button.setFocusable(false);
        button.setName("breadcrumb.right.URFileChooser");
        return button;
    }

    @Override
    public JButton createLeftButton() {
        JButton button = new JButton();
        button.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(40, 40);
        SwingBreadcrumbResourceCreator.setDimension(button, dimension);
        button.setIcon(ImageResource.arrowLeft());
        button.setFocusable(false);
        button.setName("breadcrumb.left.URFileChooser");
        return button;
    }

    @Override
    public JButton createHomeButton() {
        JButton button = new JButton();
        button.setHorizontalAlignment(2);
        button.setBorder(BorderFactory.createEmptyBorder());
        Dimension dimension = new Dimension(55, 40);
        SwingBreadcrumbResourceCreator.setDimension(button, dimension);
        button.setIcon(ImageResource.goHome());
        button.setFocusable(false);
        button.setName("homeDirectory.URFileChooser");
        return button;
    }

    @Override
    public int getSepartorWidth() {
        return (int)this.getSeparatorDimension().getWidth();
    }
}

