/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.actions;

import com.ur.lang.NamingUtils;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.resources.ImageResource;
import com.ur.swing.ViewContext;
import java.awt.event.ActionEvent;
import java.io.File;

public class CreateDirectoryAction
extends AbstractFileSystemAction {
    private final IFileChooser fileChooser;
    private final FileManagerTextResource textResource;
    private final FileSystemModel fileSystemModel;

    public CreateDirectoryAction(IFileChooser fileChooser, ViewContext viewContext, FileSystemModel fileSystemModel) {
        this.fileChooser = fileChooser;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.fileSystemModel = fileSystemModel;
        this.putValue("SmallIcon", ImageResource.folderNew());
        this.putValue("Name", this.textResource.New());
    }

    public void actionPerformed(ActionEvent e) {
        this.create(this.textResource.newFolder());
    }

    private void create(String name) {
        if (this.existsFileWithName(this.fileSystemModel.getCurrentDirectory(), name)) {
            name = this.getNewFolderName(this.fileSystemModel.getCurrentDirectory(), name);
        }
        File newDirectory = this.fileSystemModel.getFileSystemView().createFileObject(this.fileSystemModel.getCurrentDirectory(), name);
        newDirectory.mkdir();
        this.fileChooser.updateUIFields();
    }

    private boolean existsFileWithName(File currentDirectory, String newFilename) {
        File[] listOfFiles = currentDirectory.listFiles();
        assert (listOfFiles != null);
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (newFilename.equals(file.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getNewFolderName(File currentDirectory, String currentFilename, int numberAtEnd) {
        String newFilename = NamingUtils.stripNumbersOffEndOfName((String)currentFilename);
        if (this.existsFileWithName(currentDirectory, newFilename = NamingUtils.addNumberToEndOfString((String)newFilename, (int)numberAtEnd))) {
            newFilename = this.getNewFolderName(currentDirectory, currentFilename, numberAtEnd + 1);
        }
        return newFilename;
    }

    private String getNewFolderName(File currentDirectory, String currentFilename) {
        return this.getNewFolderName(currentDirectory, currentFilename, 1);
    }
}

