/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.actions;

import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ConfirmationMessageProvider;
import com.ur.polyscope.filemanager.impl.ErrorMessageProvider;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorDialogCreator;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.event.ActionEvent;
import java.io.File;

class DeleteAction
extends AbstractFileSystemAction {
    private final IFileChooser fileChooser;
    private final FileManagerTextResource textResource;
    private final ConfirmationMessageProvider confirmationMessageProvider;
    private final ErrorMessageProvider errorMessageProvider;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final ErrorDialogCreator errorDialogCreator;

    public DeleteAction(IFileChooser fileChooser, ViewContext viewContext, SharedImageResource sharedImageResource) {
        this.fileChooser = fileChooser;
        this.textResource = (FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class);
        this.confirmationMessageProvider = new ConfirmationMessageProvider(this.textResource);
        this.errorMessageProvider = new ErrorMessageProvider(this.textResource);
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.errorDialogCreator = viewContext.getDialogCreator();
        this.putValue("Name", this.textResource.DELETEFILE());
        this.putValue("SmallIcon", sharedImageResource.delete());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            final File fileToDelete = this.fileChooser.getSelectedFile();
            if (!fileToDelete.exists()) {
                throw new IllegalArgumentException("Trying to delete file: " + fileToDelete + " but it does not exist");
            }
            if (fileToDelete.isDirectory() && fileToDelete.listFiles().length > 0) {
                this.confirmationDialogCreator.showConfirmationDialog(this.confirmationMessageProvider.confirmDeleteNonEmptyDirectory(HTML.convertToHtml((String)fileToDelete.getName())), new ConfirmationDialogListener(){

                    public void onClick(DialogReturnValue returnValue) {
                        DeleteAction.this.performDeleteFullDirectory(returnValue, fileToDelete);
                    }
                });
            } else {
                this.confirmationDialogCreator.showConfirmationDialog(this.confirmationMessageProvider.confirmDeleteFile(HTML.convertToHtml((String)fileToDelete.getName())), new ConfirmationDialogListener(){

                    public void onClick(DialogReturnValue returnValue) {
                        DeleteAction.this.performDelete(returnValue, fileToDelete);
                    }
                });
            }
            this.fileChooser.updateUIFields();
        }
        catch (Exception e) {
            Log.error((String)"Failed to delete file", (Throwable)e);
            this.errorDialogCreator.showErrorDialog(this.errorMessageProvider.fatalUnknownException(this.textResource.deleteFileError()), new OkDialogListener());
        }
    }

    private void performDelete(DialogReturnValue returnValue, File fileToDelete) {
        if (returnValue.equals((Object)DialogReturnValue.OK)) {
            if (!fileToDelete.delete()) {
                return;
            }
            this.fileChooser.updateUIFields();
        }
    }

    private void performDeleteFullDirectory(DialogReturnValue returnValue, File fileToDelete) {
        if (!returnValue.equals((Object)DialogReturnValue.OK)) {
            this.fileChooser.rescan();
            return;
        }
        File[] list = fileToDelete.listFiles();
        assert (list != null);
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.performDeleteFullDirectory(returnValue, f);
            } else if (!f.delete()) {
                Log.error((String)"Could not delete file");
            }
            ++n2;
        }
        if (!fileToDelete.delete()) {
            Log.error((String)"Could not delete file");
        }
        this.fileChooser.updateUIFields();
    }
}

