/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.actions;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.filemanager.impl.FileSystemModel;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.INavigateParent;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.actions.AbstractFileSystemAction;
import com.ur.polyscope.filemanager.impl.actions.CancelAction;
import com.ur.polyscope.filemanager.impl.actions.CopyAction;
import com.ur.polyscope.filemanager.impl.actions.CreateDirectoryAction;
import com.ur.polyscope.filemanager.impl.actions.CutAction;
import com.ur.polyscope.filemanager.impl.actions.DeleteAction;
import com.ur.polyscope.filemanager.impl.actions.FileSystemActionFactory;
import com.ur.polyscope.filemanager.impl.actions.NavigateHomeAction;
import com.ur.polyscope.filemanager.impl.actions.NavigateParentAction;
import com.ur.polyscope.filemanager.impl.actions.OpenFileAction;
import com.ur.polyscope.filemanager.impl.actions.PasteAction;
import com.ur.polyscope.filemanager.impl.actions.SaveFileAction;
import com.ur.polyscope.filemanager.impl.operations.ClipboardFileHolder;
import com.ur.polyscope.filemanager.impl.operations.ClipboardOperation;
import com.ur.polyscope.filemanager.impl.usb.BackupToUSBAction;
import com.ur.polyscope.filemanager.impl.usb.IUSBFileOperation;
import com.ur.swing.ViewContext;
import javax.inject.Inject;
import javax.swing.JProgressBar;

public class FileSystemActionFactoryImpl
implements FileSystemActionFactory {
    private final ViewContext viewContext;
    private final SharedImageResource imageResource;
    private final Recipe<ClipboardFileHolder> clipboardFileHolderRecipe;
    private final IUSBFileOperation usbFileOperation;

    @Inject
    public FileSystemActionFactoryImpl(ViewContext viewContext, SharedImageResource imageResource, @Source(value=ClipboardFileHolder.class) Recipe<ClipboardFileHolder> clipboardFileHolderRecipe, IUSBFileOperation usbFileOperation) {
        this.viewContext = viewContext;
        this.imageResource = imageResource;
        this.clipboardFileHolderRecipe = clipboardFileHolderRecipe;
        this.usbFileOperation = usbFileOperation;
    }

    @Override
    public AbstractFileSystemAction getDeleteAction(IFileChooser fileChooser) {
        return new DeleteAction(fileChooser, this.viewContext, this.imageResource);
    }

    @Override
    public AbstractFileSystemAction getBackupToUSBAction(IFileChooser fileChooser) {
        return new BackupToUSBAction(fileChooser, this.viewContext, this.imageResource, this.usbFileOperation);
    }

    @Override
    public AbstractFileSystemAction getBackupToUSBAction(IFileChooser fileChooser, JProgressBar progressBar) {
        return new BackupToUSBAction(fileChooser, progressBar, this.viewContext, this.imageResource, this.usbFileOperation);
    }

    @Override
    public AbstractFileSystemAction getNavigateParentAction(INavigateParent navigateParent) {
        return new NavigateParentAction(navigateParent);
    }

    @Override
    public AbstractFileSystemAction getNavigateHomeAction(IFileChooser fileChooser) {
        return new NavigateHomeAction(fileChooser, this.imageResource);
    }

    @Override
    public AbstractFileSystemAction getSaveFileAction(IFileChooser fileChooser) {
        return new SaveFileAction(fileChooser, this.viewContext);
    }

    @Override
    public AbstractFileSystemAction getOpenFileAction(IFileChooser fileChooser) {
        return new OpenFileAction(fileChooser, this.viewContext);
    }

    @Override
    public AbstractFileSystemAction getCancelAction(IFileChooser fileChooser) {
        return new CancelAction(fileChooser, this.viewContext);
    }

    @Override
    public AbstractFileSystemAction getCopyAction(IFileChooser fileChooser, ClipboardOperation clipboardOperation) {
        return new CopyAction(fileChooser, this.viewContext, clipboardOperation);
    }

    @Override
    public AbstractFileSystemAction getCutAction(IFileChooser fileChooser, ClipboardOperation clipboardOperation) {
        return new CutAction(fileChooser, this.viewContext, clipboardOperation);
    }

    @Override
    public AbstractFileSystemAction getPasteAction(IFileChooser fileChooser, ClipboardOperation clipboardOperation) {
        return new PasteAction(this.viewContext, clipboardOperation, this.clipboardFileHolderRecipe);
    }

    @Override
    public AbstractFileSystemAction getCreateDirectoryAction(IFileChooser fileChooser, FileSystemModel fileSystemModel) {
        return new CreateDirectoryAction(fileChooser, this.viewContext, fileSystemModel);
    }
}

