/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.breadcrumb;

import com.ur.polyscope.filemanager.impl.FilePathUtils;
import com.ur.polyscope.filemanager.impl.breadcrumb.BreadcrumbResourceCreator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Breadcrumb
extends JPanel {
    private List<String> filePath = new ArrayList<String>();
    protected List<JButton> buttons = new ArrayList<JButton>();
    protected List<JButton> window = new ArrayList<JButton>();
    protected JButton home;
    protected JButton rightArrow;
    protected JButton leftArrow;
    private final List<JLabel> separators = new ArrayList<JLabel>();
    private File topDir;
    private final BreadcrumbResourceCreator resourceCreator;

    public Breadcrumb(BreadcrumbResourceCreator resourceCreator) {
        this.resourceCreator = resourceCreator;
    }

    public void setPath(File currDir, File topDir) {
        this.topDir = topDir;
        this.clear();
        String topDirPath = FilePathUtils.resolveRelativeParents(topDir.getAbsolutePath());
        String currDirPath = FilePathUtils.resolveRelativeParents(currDir.getAbsolutePath());
        String[] structure = Breadcrumb.getFileStructure(topDirPath, currDirPath);
        int i = 0;
        while (i < structure.length) {
            this.addFileButton(structure[i], "breadcrumb.prefix.URFileChooser" + i);
            ++i;
        }
        this.constructWindow(this.buttons.size() - 1);
    }

    private static String[] getFileStructure(String topDirPath, String currDirPath) {
        String[] structure = new String[]{};
        if (!currDirPath.equals(topDirPath) && currDirPath.startsWith(topDirPath)) {
            String relativePathCurrDir = currDirPath.substring(currDirPath.indexOf(topDirPath) + topDirPath.length());
            structure = relativePathCurrDir.startsWith(File.separator) ? relativePathCurrDir.substring(1).split(File.separator) : relativePathCurrDir.split(File.separator);
        }
        return structure;
    }

    private void addFileButton(String name, String buttonName) {
        final JButton button = this.resourceCreator.createFileButton(name, buttonName);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Breadcrumb.this.buttons.indexOf(button);
                List newFilePath = Breadcrumb.this.filePath.subList(0, index + 1);
                if (!Breadcrumb.this.filePath.equals(newFilePath)) {
                    Breadcrumb.this.updateBreadCrumb(newFilePath, Breadcrumb.this.buttons.subList(0, index + 1), index);
                }
            }
        });
        this.filePath.add(name);
        this.buttons.add(button);
    }

    private void constructWindow(int toIndex) {
        this.clearWindow();
        this.addHomeButton();
        double cumulativeWidth = this.home.getPreferredSize().getWidth() + this.leftArrow.getPreferredSize().getWidth() + this.rightArrow.getPreferredSize().getWidth();
        int i = toIndex;
        while (i >= 0) {
            JButton button = this.buttons.get(i);
            cumulativeWidth += button.getPreferredSize().getWidth();
            if (i != 0 && i != toIndex) {
                cumulativeWidth += (double)this.resourceCreator.getSepartorWidth();
            }
            if (!(cumulativeWidth <= this.getPreferredSize().getWidth())) {
                this.addLeftArrow();
                break;
            }
            this.window.add(button);
            --i;
        }
        Collections.reverse(this.window);
        ListIterator<JButton> iterator = this.window.listIterator();
        this.addSeparators(iterator);
        if (toIndex < this.buttons.size() - 1) {
            this.addRightArrow();
        }
        this.revalidate();
        this.repaint();
    }

    private void addSeparators(ListIterator<JButton> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
            if (!iterator.hasNext() || !iterator.hasPrevious()) continue;
            JLabel label = this.resourceCreator.createSeparatorIcon();
            this.separators.add(label);
            this.add(label);
        }
    }

    private void addHomeButton() {
        this.add(this.home);
        this.home.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Breadcrumb.this.filePath.isEmpty()) {
                    Breadcrumb.this.setPath(Breadcrumb.this.topDir, Breadcrumb.this.topDir);
                    Breadcrumb.this.notifyActionListeners();
                }
            }
        });
    }

    private void addRightArrow() {
        this.add(this.rightArrow);
        this.rightArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Breadcrumb.this.constructWindow(Breadcrumb.this.buttons.indexOf(Breadcrumb.this.window.get(Breadcrumb.this.window.size() - 1)) + 1);
            }
        });
    }

    private void addLeftArrow() {
        this.add(this.leftArrow);
        this.leftArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Breadcrumb.this.constructWindow(Breadcrumb.this.buttons.indexOf(Breadcrumb.this.window.get(Breadcrumb.this.window.size() - 1)) - 1);
            }
        });
    }

    private void clearWindow() {
        if (this.home != null) {
            this.remove(this.home);
        }
        for (JButton button : this.window) {
            this.remove(button);
        }
        for (JLabel label : this.separators) {
            this.remove(label);
        }
        this.separators.clear();
        this.window.clear();
        if (this.rightArrow != null) {
            this.remove(this.rightArrow);
        }
        if (this.leftArrow != null) {
            this.remove(this.leftArrow);
        }
        this.rightArrow = this.resourceCreator.createRightButton();
        this.leftArrow = this.resourceCreator.createLeftButton();
        this.home = this.resourceCreator.createHomeButton();
    }

    private void clear() {
        this.filePath = new ArrayList<String>();
        this.buttons = new ArrayList<JButton>();
    }

    private void updateBreadCrumb(List<String> newFilePath, List<JButton> newButtons, int index) {
        for (JButton btn : this.buttons.subList(index + 1, this.buttons.size())) {
            this.remove(btn);
        }
        this.clear();
        this.filePath.addAll(newFilePath);
        this.buttons.addAll(newButtons);
        this.constructWindow(this.buttons.size() - 1);
        this.revalidate();
        this.repaint();
        this.notifyActionListeners();
    }

    public File getDirectory(Iterable<String> filePath) {
        StringBuilder builder = new StringBuilder();
        for (String name : filePath) {
            builder.append(name);
            builder.append(File.separator);
        }
        return new File(String.valueOf(this.topDir.getAbsolutePath()) + File.separator + builder);
    }

    public File getCurrentDirectory() {
        return this.getDirectory(this.filePath);
    }

    private void notifyActionListeners() {
        ActionListener[] actionListeners;
        ActionListener[] actionListenerArray = actionListeners = (ActionListener[])this.getListeners(ActionListener.class);
        int n = actionListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(new ActionEvent(this, 1001, null));
            ++n2;
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }
}

