/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.operations.ClipboardFileHolder;
import java.io.File;

public final class ClipboardFileHolderImpl
implements ClipboardFileHolder {
    private File sourceFile;
    private File sourceDirectory;
    private boolean isCut;

    private ClipboardFileHolderImpl(IFileChooser fileChooser, boolean isCut) {
        this.isCut = isCut;
        this.sourceFile = fileChooser.getSelectedFile();
        this.sourceDirectory = fileChooser.getCurrentDirectory();
    }

    @Override
    public boolean isAvailable() {
        return this.sourceFile.exists();
    }

    @Override
    public File getClipboardFile() {
        return this.sourceFile;
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    @Override
    public boolean isValidPaste(File currentDirectory) {
        if (this.isCut && this.sourceDirectory.equals(currentDirectory)) {
            return false;
        }
        return this.sourceFile.exists();
    }

    public static ClipboardFileHolderImpl doCut(IFileChooser fileChooser) {
        return new ClipboardFileHolderImpl(fileChooser, true);
    }

    public static ClipboardFileHolderImpl doCopy(IFileChooser fileChooser) {
        return new ClipboardFileHolderImpl(fileChooser, false);
    }
}

