/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.concept.operations.ConceptOperation;
import com.ur.polyscope.concept.operations.CopyOperationBuilder;
import com.ur.polyscope.concept.operations.MoveOperationBuilder;
import com.ur.polyscope.concept.operations.UserInputResource;
import com.ur.polyscope.concept.operations.internal.UserInputResourceImpl;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.location.LocationType;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.filemanager.i18n.FileManagerTextResource;
import com.ur.polyscope.filemanager.impl.ConfirmationMessageProvider;
import com.ur.polyscope.filemanager.impl.FileExtensions;
import com.ur.polyscope.filemanager.impl.IFileChooser;
import com.ur.polyscope.filemanager.impl.operations.ClipboardFileHolder;
import com.ur.polyscope.filemanager.impl.operations.ClipboardFileHolderImpl;
import com.ur.polyscope.filemanager.impl.operations.ClipboardModelSource;
import com.ur.polyscope.filemanager.impl.operations.NullClipboardFileHolder;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FilenameUtils;

public class ClipboardOperation {
    private final IFileChooser fileChooser;
    private final ClipboardModelSource clipboardModelSource;
    private final ConceptLocationFactory conceptLocationFactory;
    private ClipboardFileHolder currentClipboardFileHolder;
    private final CopyOperationBuilder copyOperationBuilder;
    private final MoveOperationBuilder moveOperationBuilder;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final ConfirmationMessageProvider confirmationMessageProvider;
    private final ViewContext viewContext;

    public ClipboardOperation(IFileChooser fileChooser, ClipboardModelSource clipboardModelSource, MoveOperationBuilder moveOperationBuilder, CopyOperationBuilder copyOperationBuilder, ConceptLocationFactory conceptLocationFactory, ViewContext viewContext) {
        this.fileChooser = fileChooser;
        this.clipboardModelSource = clipboardModelSource;
        this.conceptLocationFactory = conceptLocationFactory;
        this.currentClipboardFileHolder = new NullClipboardFileHolder();
        this.moveOperationBuilder = moveOperationBuilder;
        this.copyOperationBuilder = copyOperationBuilder;
        clipboardModelSource.emit(this.currentClipboardFileHolder);
        this.confirmationDialogCreator = viewContext.getDialogCreator();
        this.confirmationMessageProvider = new ConfirmationMessageProvider((FileManagerTextResource)viewContext.getTextResource(FileManagerTextResource.class));
        this.viewContext = viewContext;
    }

    public void newCopyFileHolder() {
        if (this.fileChooser.isFileSelected()) {
            this.currentClipboardFileHolder = ClipboardFileHolderImpl.doCopy(this.fileChooser);
            this.clipboardModelSource.emit(this.currentClipboardFileHolder);
        } else {
            this.currentClipboardFileHolder = new NullClipboardFileHolder();
            this.clipboardModelSource.emit(this.currentClipboardFileHolder);
        }
    }

    public void newCutFileHolder() {
        if (this.fileChooser.isFileSelected()) {
            this.currentClipboardFileHolder = ClipboardFileHolderImpl.doCut(this.fileChooser);
            this.clipboardModelSource.emit(this.currentClipboardFileHolder);
        } else {
            this.currentClipboardFileHolder = new NullClipboardFileHolder();
            this.clipboardModelSource.emit(this.currentClipboardFileHolder);
        }
    }

    public ClipboardFileHolder getClipboardFileHolder() {
        return this.currentClipboardFileHolder;
    }

    public void removeClipboardFileHolder() {
        this.currentClipboardFileHolder = new NullClipboardFileHolder();
        this.clipboardModelSource.emit(this.currentClipboardFileHolder);
    }

    public void rescanClipboardFileHolder() {
        this.clipboardModelSource.emit(this.currentClipboardFileHolder);
    }

    public void doNormalPaste() {
        File sourceFile = this.currentClipboardFileHolder.getClipboardFile();
        String newFilename = sourceFile.getName();
        final boolean[] canCopy = new boolean[]{true};
        if (this.existsFileWithName(this.fileChooser.getCurrentDirectory(), newFilename)) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.confirmationDialogCreator.showConfirmationDialog(this.confirmationMessageProvider.confirmOverwriteFile(newFilename), new ConfirmationDialogListener(){

                public void onCancelClicked() {
                    canCopy[0] = false;
                    latch.countDown();
                }

                public void onOkClicked() {
                    canCopy[0] = true;
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (canCopy[0]) {
            File newFile = new File(this.fileChooser.getCurrentDirectory(), newFilename);
            try {
                FileUtils.copy((File)sourceFile, (File)newFile);
            }
            catch (IOException e) {
                Log.error((String)"Unable to paste file", (Throwable)e);
                return;
            }
            if (this.currentClipboardFileHolder.isCut()) {
                sourceFile.delete();
                this.removeClipboardFileHolder();
            }
        }
    }

    private void doConceptPaste(LocationType type) {
        File sourceFile = this.currentClipboardFileHolder.getClipboardFile();
        File sourceDirectory = sourceFile.getParentFile();
        File newDir = this.fileChooser.getCurrentDirectory();
        ConceptLocation originalLocation = this.conceptLocationFactory.get(FilenameUtils.removeExtension((String)sourceFile.getName()), sourceDirectory.getPath(), type);
        ConceptLocation newLocation = this.conceptLocationFactory.get(FilenameUtils.removeExtension((String)sourceFile.getName()), newDir.getPath(), type);
        boolean canExecuteAll = true;
        ArrayList<String> errorMessages = new ArrayList<String>();
        UserInputResourceImpl overwriteInput = new UserInputResourceImpl(this.viewContext);
        List conceptOperations = this.currentClipboardFileHolder.isCut() ? this.moveOperationBuilder.buildMove(originalLocation, newLocation, (UserInputResource)overwriteInput) : this.copyOperationBuilder.buildCopy(originalLocation, newLocation, (UserInputResource)overwriteInput);
        for (ConceptOperation conceptOperation : conceptOperations) {
            if (conceptOperation.canExecute()) continue;
            canExecuteAll = false;
            errorMessages.add(conceptOperation.getError());
            break;
        }
        this.clipboardModelSource.emit(new NullClipboardFileHolder());
        if (canExecuteAll) {
            for (ConceptOperation conceptOperation : conceptOperations) {
                conceptOperation.execute();
            }
            this.clipboardModelSource.emit(this.currentClipboardFileHolder);
        } else {
            for (String errorMessage : errorMessages) {
                Log.error((String)errorMessage);
            }
        }
        if (this.currentClipboardFileHolder.isCut()) {
            this.removeClipboardFileHolder();
        }
    }

    public void doPaste() {
        if (!this.currentClipboardFileHolder.isValidPaste(this.fileChooser.getCurrentDirectory())) {
            this.removeClipboardFileHolder();
            return;
        }
        if (FileExtensions.isProgram(this.currentClipboardFileHolder.getClipboardFile())) {
            this.doConceptPaste(Types.getProgram());
        } else {
            this.doNormalPaste();
        }
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ClipboardOperation.this.fileChooser.updateUIFields();
            }
        });
    }

    private boolean existsFileWithName(File currentDirectory, String newFilename) {
        File[] listOfFiles = currentDirectory.listFiles();
        assert (listOfFiles != null);
        File[] fileArray = listOfFiles;
        int n = listOfFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (newFilename.equals(file.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

