/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.SwingFileRenderer;
import com.ur.polyscope.filemanager.impl.SharedImageResource;
import com.ur.polyscope.filemanager.impl.SharedStyleResource;
import com.ur.polyscope.filemanager.impl.usb.USBDirectoryFilter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.inject.Inject;
import javax.swing.BorderFactory;

public class DefaultFileRenderer
extends SwingFileRenderer.Template {
    private SharedImageResource imageResource;
    private SharedStyleResource styleResource;
    private USBDirectoryFilter usbDirectoryFilter;

    @Inject
    public DefaultFileRenderer(SharedImageResource imageResource, SharedStyleResource styleResource, USBDirectoryFilter usbDirectoryFilter) {
        this.imageResource = imageResource;
        this.styleResource = styleResource;
        this.usbDirectoryFilter = usbDirectoryFilter;
    }

    public Component render(File file, boolean isSelected, boolean cellHasFocus) {
        Color focusColor = isSelected ? this.styleResource.focusColor() : this.styleResource.unfocusColor();
        this.setBorder(BorderFactory.createLineBorder(focusColor, 3));
        this.setBackground(cellHasFocus ? focusColor : this.styleResource.unfocusColor());
        if (file.isDirectory()) {
            this.setFont(this.getFont().deriveFont(this.styleResource.directoryFontStyle()));
            this.setForeground(isSelected ? this.styleResource.fileColor() : this.styleResource.directoryColor());
            this.setIcon(this.usbDirectoryFilter.isUSBDriveRoot(file) ? this.imageResource.usb() : this.imageResource.folder());
        } else {
            this.setFont(this.getFont().deriveFont(this.styleResource.fileFontStyle()));
            this.setForeground(this.styleResource.fileColor());
            this.setIcon(this.imageResource.defaultFile());
        }
        this.setText(file.getName());
        return this;
    }
}

