/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager.impl.operations;

import com.ur.polyscope.filemanager.FileStrategy;
import com.ur.util.logging.Log;
import java.io.File;

public class DefaultFileStrategy
extends FileStrategy {
    public DefaultFileStrategy() {
        super("");
    }

    public String getInputDisplayName(String input) {
        int extensionIndex = input.lastIndexOf(46);
        if (extensionIndex > -1) {
            return input.substring(0, extensionIndex);
        }
        return input;
    }

    public boolean isSupported(String oldFileName) {
        return true;
    }

    public void renameFile(File sourceFile, File destinationFile) {
        String extension = this.getExtension(sourceFile.getName());
        if (!destinationFile.getAbsolutePath().endsWith(extension)) {
            destinationFile = new File(String.valueOf(destinationFile.getAbsolutePath()) + extension);
        }
        if (!sourceFile.renameTo(destinationFile)) {
            Log.error((String)"Could not rename file");
        }
    }

    private String getExtension(String name) {
        int extensionIndex = name.lastIndexOf(46);
        if (extensionIndex > -1) {
            return name.substring(extensionIndex, name.length());
        }
        return "";
    }
}

